--[[
#---------------------------------------------------------------#
----*			DayZ MTA Script editor_server.lua			*----
----* This Script is owned by Marwin, you are allowed to edit it.
----* Owner: Marwin W., Germany, Lower Saxony, Otterndorf
----* Skype: xxmavxx96
----*														*----
#---------------------------------------------------------------#
]]

--SERVER OUTPUTS
shownInfos = {}

	shownInfos["nomag"] = "No magazines left for this weapon!"
	shownInfos["youconsumed"] = "You consumed"
	shownInfos["needwatersource"] = "You have to be inside a body of water!"
	shownInfos["filledup"] = "You filled your Water Bottle up!"
	shownInfos["noradio"] = "You have no Radio Device!"
	
--GAMEPLAY SETUP
gameplayVariables = {}

	gameplayVariables["zombieblood"] = 6000 -- Zombie Blood/Health - DEFAULT: 6000
	gameplayVariables["foodrestore"] = math.random(40,100) -- Amount of hunger to be restored when eating - DEFAULT: math.random(40,100) - FOR FULL RESTORE, JUST WRITE 100
	gameplayVariables["thirstrestore"] = math.random(40,100) -- Amount of hunger to be restored when drinking - DEFAULT: math.random(40,100) - FOR FULL RESTORE, JUST WRITE 100
	gameplayVariables["loseHunger"] = -1.5 -- Amount of losing hunger per minute - DEFAULT: -1.5
	gameplayVariables["loseThirst"] = -1.5 -- Amount of losing thirst per minute - DEFAULT: -1.5
	gameplayVariables["playerzombies"] = 6 -- Amount of spawning zombies per player - DEFAULT: 6 - THE HIGHER THIS VALUE, THE MORE LAG CAN OCCUR!
	gameplayVariables["amountzombies"] = 3 -- Amount of zombies - DEFAULT: 3 - THE HIGHER THIS VALUE, THE MORE LAG CAN OCCUR!
	gameplayVariables["temperaturewater"] = -0.01 -- Amount of temperature to be lost when in water - DEFAULT: -0.01
	gameplayVariables["temperaturesprint"] = 0.005 -- Amount of temperature to be gained when sprinting - DEFAULT: 0.005
	gameplayVariables["sprintthirst"] = -0.2 -- Amount of losing thirst when sprinting - DEFAULT: -0.2
	gameplayVariables["enablenight"] = true -- Whether or not the night should be darker - DEFAULT: true - SET TO false to disable - remember you need to set it in editor_client.lua too.
	gameplayVariables["itemrespawntimer"] = 14400000 -- Number of milliseconds that should elapse before the items will respawn. Note: You can also just do 14400000/2 to make it the half from the current (division).

	
-- SERVER BACKUP
	gameplayVariables["backupenabled"] = true -- Whether or not backup should be enabled. Backup = saves all tents, accounts & vehicles. - DEFAULT: true - Set to false to disable backup.
	gameplayVariables["backupinterval"] = 86400000 -- Number of milliseconds that should elapse before backup. Minimum: 50. - 1000 milliseconds = 1 second. - DEFAULT: 86400000 (= 24 hours)

	
	
-- VEHICLE SPAWNPOINTS
-- HUNTER
gameplayVariables["hunterspawns"] = 
{
{-1185.9775390625,26.4111328125,14.1484375},
{-1724.5830078125,2559.3544921875,104.09127807617},
{615.744140625,850.1572265625,-43.009014129639},
{232.5283203125,1950.3583984375,17.640625},
{-1050.5859375,1968.033203125,120.66523742676},
{2821.03515625,2809.6689453125,10.8203125},
{1949.9912109375,-2631.44140625,13.546875},
{-756.53979492188,-2137.5471191406,26.463499069214},
}

-- PATRIOT
gameplayVariables["patriotspawns"] =
{
{-1473.5791015625,320.2294921875,7.1875},
{-1373.998046875,460.62109375,7.1875},
{419.150390625,2186.087890625,39.499450683594},
{2821.1796875,793.4658203125,10.8984375},
}

-- PICKUP
gameplayVariables["pickupspawns"] =
{
{-2479.6240234375,2223.6669921875,4.84375},
{-92.9951171875,2823.0908203125,76.721649169922},
{-2448.99609375,-1335.8662109375,310.97662353516},
{-173.2470703125,-2635.5341796875,26.608192443848},
{2108.447265625,-1600.916015625,13.552597045898},
{2452.7392578125,1607.9833984375,10.8203125},
{-1800.8984375,-1950.9736328125,93.561332702637},
}

-- SANCHEZ
gameplayVariables["sanchezspawns"] = 
{
{-812.470703125,-2629.912109375,90.105056762695},
{-1729.8525390625,-1940.3154296875,99.840209960938},
{-2130.90234375,178.4375,35.257678985596},
{-2656.7333984375,1352.4873046875,7.0596733093262},
{-1598.302734375,2694.947265625,55.07092666626},
{-809.96484375,2430.037109375,156.97012329102},
{2920.38671875,2486.0087890625,10.8203125},
{505.732421875,-291.8681640625,20.00952911377},
{-428.8828125,-694.8310546875,19.14847946167},
{1190.41015625,-2109.0341796875,64.738548278809},
{1658.9716796875,-1069.0224609375,23.906229019165},
}

-- BARRACKS
gameplayVariables["barracksspawns"] =
{
{86.486328125,1950.9013671875,17.846803665161},
{440.185546875,1464.173828125,6.3338670730591},
}

-- COACH
gameplayVariables["coachspawns"] =
{
{-1971.4619140625,97.4658203125,27.6875},
{1735.8720703125,1429.0693359375,10.797702789307},
{2797.1318359375,-1868.8359375,9.8603811264038},
{1941.900390625,1975.1904296875,7.59375},
}

-- FISHERBOAT
gameplayVariables["fisherboatspawns"] =
{
{2463.3984375,-2719.638671875,-0.55000001192093},
{-1577.4873046875,182.353515625,-0.53995263576508},
{-806.80859375,2233.7001953125,40.049976348877},
{-127.4453125,-779.6923828125,-0.55000001192093},
}

-- BIKE
gameplayVariables["bikespawns"] =
{
{194.685546875,-120.2333984375,1.5497757196426},
{173.0146484375,-95.0634765625,1.5516006946564},
{2369.9599609375,29.712890625,28.0416431427},
{710.87109375,-566.7548828125,16.3359375},
{1109.6025390625,-1667.6689453125,13.615442276001},
{2014.6689453125,-1113.4013671875,26.203125},
{2447.41015625,-1967.1845703125,13.546875},
{2633.7236328125,1835.291015625,11.0234375},
{1489.3974609375,2681.54296875,10.8203125},
{-2428.5654296875,2280.875,4.984375},
{-2501.0869140625,2224.880859375,4.9861993789673},
{-2142.8515625,-2457.84765625,30.625},
{-2456.078125,-141.115234375,26.112222671509},
{-1881.4453125,954.3837890625,35.171875},
}

-- MAVERICK
gameplayVariables["maverickspawns"] = 
{
{-1495.888671875,-2691.40234375,57.325229644775},
{-2688.42578125,1471.634765625,7.1875},
{-1534.28125,2842.9482421875,97.463409423828},
{2221.8583984375,-1344.396484375,23.984273910522},
}

-- TENTS (REFERS TO SURVIVOR CAMPS!!!)
gameplayVariables["tentsspawns"] =
{
{-2845.060546875,2761.2509765625,242.69204711914},
{-1095.94921875,-1450.958984375,126.92543029785},
{2607.1357421875,-510.4755859375,80.744903564453},
{-1509.2333984375,-1986.443359375,50.071846008301},
}

-- HELI CRASH SIDES
gameplayVariables["helicrashsides"] = 
{
{-1360.0478515625,-1070.7314453125,160.4069519043},
{-421.4619140625,-1284.4345703125,33.740924835205},
{-2357.654296875,-1634.3623046875,483.703125},
{979.0849609375,160.59375,28.935249328613},
{-2057.2294921875,2781.73828125,163.12780761719},
{826.90234375,2803.6259765625,74.863929748535},
{2577.7060546875,-650.541015625,136.37449645996},
}


-- SPAWNPOINTS (ITEMS)
pickupPositions = {
["industrial"] = {

{2776.3916015625,-2445.9912109375,13.63644695282},
{2776.302734375,-2465.4873046875,13.636467933655},
{2794.921875,-2483.4482421875,13.641567230225},
{2776.123046875,-2504.1513671875,13.633953094482},
{2743.7646484375,-2452.8408203125,13.86225605011},
{2799.1015625,-2393.4853515625,13.95600605011},
{-2457.4091796875,777.58203125,35.171875},
{2776.4013671875,-2408.6435546875,13.648777008057},
{2786.978515625,-2428.1826171875,13.633860588074},
{2505.9169921875,-2454.0302734375,17.882808685303},
{2513.732421875,-2417.6318359375,17.882808685303},
{2430.7978515625,-2467.2958984375,13.632326126099},
{2503.6875,-2640.958984375,13.86225605011},
{2156.107421875,-2667.9794921875,17.882808685303},
{2522.244140625,-2207.9345703125,17.357162475586},
{2582.486328125,-2207.126953125,17.357162475586},
{2707.0185546875,-2188.779296875,13.546875},
{2588.0048828125,-2192.29296875,13.546875},
{2198.08984375,-2412.8046875,13.546875},
{-2717.859375,197.87109375,4.3418498039246},
{-2729.1767578125,72.939453125,4.3359375},
{-2742.349609375,129.5283203125,4.5390625},
{2210.150390625,-2205.2861328125,15.171091079712},
{2160.1572265625,-2232.23828125,13.305326461792},
{2167.23046875,-2264.46875,13.309000968933},
{2222.744140625,-2273.068359375,14.764669418335},
{2272.5087890625,-2264.4091796875,14.764669418335},
{-2528.4912109375,-20.396484375,16.421875},
{2094.72265625,-2155.9580078125,13.6328125},
{-2492.84375,155.6650390625,8.4730567932129},
{-2489.359375,94.734375,25.6171875},
{1984.5498046875,-2155.3212890625,13.546875},
{2163.51953125,-1988.986328125,14.133599281311},
{2228.294921875,-2060.638671875,13.546875},
{2201.482421875,-1969.498046875,13.78413105011},
{2225.234375,-2040.5390625,17.271224975586},
{-2562.443359375,323.0859375,10.5625},
{2371.6875,-2114.6640625,27.1796875},
{-2498.576171875,315.3271484375,29.1328125},
{2512.251953125,-2073.181640625,26.5546875},
{1856.962890625,-2336.6005859375,13.546875},
{1840.83203125,-2638.27734375,13.546875},
{2133.15234375,-2410.599609375,13.546875},
{1683.9970703125,-2006.8037109375,14.129119873047},
{-2312.7890625,-81.3466796875,35.3203125},
{-2151.6669921875,-147.22265625,36.467098236084},
{-2138.875,-247.572265625,36.515625},
{-2181.48828125,-205.2939453125,36.515625},
{-2109.4970703125,1.3935546875,35.3203125},
{-2026.8974609375,67.322265625,28.691593170166},
{-2102.4658203125,-16.56640625,35.3203125},
{2014.154296875,-2142.572265625,13.546875},
{-2135.8994140625,260.365234375,35.416137695312},
{-2060.3955078125,254.4658203125,37.178237915039},
{-2038.4873046875,171.05078125,28.8359375},
{2517.330078125,-1975.669921875,15.806817054749},
{2490.5400390625,-1975.6357421875,15.806816101074},
{2440.1650390625,-1970.5771484375,13.546875},
{-2054.3291015625,309.2421875,41.864288330078},
{-1942.6982421875,271.9892578125,41.047080993652},
{-1905.5556640625,220.7880859375,35.15625},
{2440.7470703125,-1899.701171875,13.553356170654},
{-1811.0859375,-228.443359375,18.375},
{-1890.5712890625,-205.8447265625,14.304314613342},
{-1812.966796875,-136.107421875,6.1635961532593},
{-1864.2919921875,-145.5126953125,11.8984375},
{-1723.8125,-115.4794921875,3.5489187240601},
{-1577.10546875,25.8125,17.328125},
{-1699.376953125,76.025390625,3.5546875},
{-1639.8642578125,-35.89453125,3.8062529563904},
{-2094.9404296875,-104.001953125,35.3203125},
{-1979.365234375,426.9423828125,24.620567321777},
{2107.96484375,-1876.0947265625,13.546875},
{-1959.6044921875,620.4697265625,35.15119934082},
{1918.2236328125,-1864.302734375,13.561338424683},
{1851.8330078125,-1854.669921875,13.3828125},
{1855.572265625,-1857.4453125,13.3828125},
{-1606.2333984375,672.068359375,-4.90625},
{-1614.291015625,687.51171875,7.1875},
{1659.78515625,-1802.490234375,13.551996231079},
{1600.4599609375,-1842.94140625,13.500748634338},
{1610.8515625,-1897.546875,13.547914505005},
{-2277.353515625,528.3818359375,35.171875},
{-2567.2490234375,552.7353515625,14.560428619385},
{-2447.671875,522.552734375,30.3671875},
{1180.7099609375,-1877.30078125,13.558115959167},
{867.7431640625,-1799.00390625,13.815788269043},
{534.6474609375,-1819.181640625,6.5712623596191},
{403.716796875,-1729.150390625,9.3225193023682},
{-2661.3984375,780.7861328125,49.984375},
{477.9423828125,-1745.3037109375,9.3753871917725},
{-2569.2197265625,850.6640625,54.728054046631},
{-2473.40625,1065.9775390625,55.7265625},
{-1951.9853515625,305.5302734375,41.047080993652},
{-1952.626953125,306.1337890625,35.46875},
{-1942.427734375,276.8486328125,35.473926544189},
{-1924.1845703125,307.748046875,41.046875},
{-1828.5634765625,49.87890625,15.122790336609},
{-1706.7421875,-4.7578125,3.5489187240601},
{-1720.9599609375,11.4248046875,3.6017475128174},
{-1253.5400390625,48.671875,14.136159896851},
{-1478.693359375,-43.5625,6},
{-1477.609375,-42.32421875,6},
{-1476.90234375,-58.015625,6},
{-1386.990234375,-128.1787109375,6},
{-1388.478515625,-284.5263671875,6},
{-1448.7568359375,-564.4248046875,14.171875},
{-1472.970703125,-518.5029296875,14.171875},
{-1405.8056640625,-536.5751953125,14.171875},
{-1333.8408203125,-504.0439453125,14.171875},
{-1391.2783203125,-481.28515625,14.17760848999},
{-1373.59765625,-523.1064453125,14.387755393982},
{-2254.005859375,2384.23828125,4.8753604888916},
{-2283.8837890625,2286.287109375,5.0520958900452},
{-2292.5751953125,2288.9736328125,4.9279627799988},
{-1827.052734375,673.751953125,30.43127822876},
{2642.6103515625,-1954.4521484375,13.546875},
{-2438.6748046875,1028.6884765625,50.390625},
{988.9541015625,-1751.853515625,13.501810073853},
{-2385.6103515625,2216.5029296875,4.984375},
{-2434.7314453125,2259.6591796875,4.984375},
{-2434.7138671875,2313.1669921875,4.984375},
{-2277.4765625,541.400390625,35.171875},
{-2237.4697265625,2353.96875,4.9795379638672},
{-2237.6259765625,2328.5283203125,4.9917659759521},
{-2186.2587890625,2417.8935546875,5.1900615692139},
{-1976.796875,1222.302734375,31.804220199585},
{1059.9755859375,-1607.0107421875,20.486064910889},
{-2163.0830078125,1232.802734375,33.9296875},
{-1389.384765625,2631.7880859375,55.984375},
{1217.2373046875,-1694.0810546875,19.734375},
{-2232.9521484375,1108.0458984375,80.000846862793},
{1275.37109375,-1693.55859375,19.734375},
{1271.240234375,-1663.734375,19.734375},
{-1695.42578125,1035.39453125,45.2109375},
{-1477.6123046875,2641.919921875,58.787948608398},
{-1484.66796875,2613.5341796875,58.787948608398},
{-1477.1865234375,2612.6484375,58.78125},
{-1484.5830078125,2641.2255859375,58.78125},
{-1421.85546875,2592.2119140625,55.805564880371},
{-1512.234375,1277.25390625,7.1793155670166},
{-1581.439453125,1277.2626953125,7.1793193817139},
{-1505.345703125,2625.1787109375,55.8359375},
{-1740.6875,1429.1533203125,7.1875},
{-1734.6669921875,1480.083984375,7.1875},
{-1734.6396484375,1526.626953125,7.1875},
{-1459.62109375,2616.5546875,55.8359375},
{-1783.3955078125,1479.1494140625,7.1875},
{-1834.2744140625,1429.4599609375,7.1875},
{-1828.0693359375,1503.068359375,7.1841449737549},
{-1936.0712890625,1492.87109375,7.1846542358398},
{-1904.830078125,1461.33984375,7.1784248352051},
{-1976.72265625,1272.982421875,7.6033039093018},
{-1788.0654296875,1209.064453125,25.125},
{-1784.8193359375,1209.0751953125,25.125},
{2728.212890625,-2381.5576171875,17.340341567993},
{2649.189453125,-2380.65625,17.340341567993},
{2771.345703125,-1628.1552734375,12.177460670471},
{2767.8173828125,-1606.0390625,10.921875},
{2662.1533203125,-1591.6259765625,13.733552932739},
{2657.189453125,-1589.662109375,13.975473403931},
{2686.1572265625,-1472.4228515625,30.562562942505},
{2786.0751953125,-1436.072265625,30.453125},
{2784.5732421875,-1466.1904296875,30.453125},
{2779.732421875,-1415.9208984375,24.745338439941},
{2052.8408203125,-1093.19140625,24.60772895813},
{1988.037109375,-1083.453125,24.847997665405},
{2128.4111328125,-1153.3740234375,23.999715805054},
{2209.7900390625,-1183.6982421875,33.53125},
{2195.6474609375,-1153.080078125,33.524044036865},
{2413.5537109375,-1433.1435546875,24.002767562866},
{2410.8359375,-1410.435546875,24.116115570068},
{1880.806640625,-1312.376953125,14.500373840332},
{1888.21875,-1320.0537109375,14.500373840332},
{1863.4541015625,-1305.39453125,13.564666748047},
{1912.0556640625,-1777.8564453125,13.3828125},
{2195.7939453125,-1506.9921875,23.942268371582},
{2188.78125,-1506.7568359375,23.934396743774},
{2182.078125,-1503.638671875,23.953277587891},
{2174.5849609375,-1502.818359375,23.956878662109},
{2482.080078125,-1464.7060546875,24.016670227051},
{2507.96875,-1470.78125,24.035413742065},
{-1438.2265625,1491.7197265625,1.8671875},
{-1393.9892578125,1482.345703125,1.8671875},
{-1384.146484375,1485.1513671875,8.90625},
{-1375.58203125,1488.880859375,11.203125},
{-1477.5126953125,1491.2021484375,8.2578125},
{-2472.4375,1551.5849609375,33.227333068848},
{-2474.591796875,1554.1279296875,33.234375},
{-2473.9599609375,1533.3359375,28.828125},
{-2388.375,1547.650390625,2.1171875},
{-2366.5205078125,1535.642578125,2.1171875},
{-769.458984375,1483.8896484375,24.552076339722},
{-897.0498046875,1970.2177734375,60.635875701904},
{2442.919921875,-1759.125,13.591394424438},
{-911.96875,2686.4091796875,42.370262145996},
{-738.3603515625,2755.755859375,47.2265625},
{-226.3466796875,1407.875,69.9375},
{-317.9130859375,2659.14453125,63.869228363037},
{388.6513671875,2603.099609375,16.484375},
{377.728515625,2590.71484375,16.484375},
{315.5087890625,2543.5087890625,16.812480926514},
{335.2490234375,2548.2568359375,16.802839279175},
{301.111328125,2543.0947265625,16.819511413574},
{280.3330078125,2542.486328125,16.817897796631},
{212.16796875,1811.8154296875,21.8671875},
{210.9345703125,1834.892578125,17.640625},
{237.46875,1857.9521484375,17.856994628906},
{246.6162109375,1859.0380859375,14.084012985229},
{245.3564453125,1876.9365234375,8.7578125},
{240.4501953125,1861.759765625,8.7578125},
{266.8359375,1839.326171875,6.4769406318665},
{248.4287109375,1816.5673828125,7.5546875},
{214.4873046875,1826.7333984375,6.4140625},
{187.6884765625,1371.734375,23.734375},
{1576.45703125,-1474.689453125,14.220542907715},
{215.294921875,1467.6572265625,23.734375},
{246.6611328125,1436.59375,23.37028503418},
{247.2685546875,1386.244140625,23.37028503418},
{153.4189453125,1392.3291015625,10.5859375},
{152.869140625,1427.5263671875,10.591223716736},
{120.7529296875,1457.1083984375,10.62112903595},
{353.9873046875,1304.2353515625,13.362517356873},
{434.228515625,1271.048828125,10.023582458496},
{625.8408203125,1358.8427734375,13.182829856873},
{577.0146484375,1427.8330078125,12.331267356873},
{538.203125,1472.2490234375,5.6047048568726},
{486.564453125,1529.7919921875,1.4532699584961},
{436.458984375,1566.5390625,12.784392356873},
{-99.3193359375,1085.2294921875,19.7421875},
{321.30859375,872.3779296875,20.399021148682},
{322.3681640625,857.4912109375,20.40625},
{565.2353515625,824.109375,-22.127143859863},
{680.2529296875,827.109375,-38.992092132568},
{691.91796875,847.9931640625,-39.007717132568},
{587.9296875,871.0205078125,-42.497318267822},
{816.4755859375,856.998046875,12.7890625},
{565.2099609375,1311.640625,11.268767356873},
{801.9951171875,1669.6689453125,5.28125},
{769.88671875,2053.193359375,6.7109375},
{782.0654296875,2067.880859375,6.7109375},
{756.97265625,2075.8623046875,6.7109375},
{1049.11328125,2908.890625,47.82311630249},
{1065.9228515625,2914.05859375,47.82311630249},
{2006.623046875,2908.3876953125,47.82311630249},
{2024.85546875,2914.5341796875,47.82311630249},
{2810.7294921875,2918.40234375,36.5046043396},
{2918.853515625,2119.3095703125,17.895481109619},
{2818.671875,854.90234375,10.016822814941},
{2856.1015625,855.2392578125,9.9886856079102},
{2845.658203125,953.3330078125,10.75},
{2816.5166015625,971.9853515625,10.75},
{2699.150390625,876.2041015625,10.457724571228},
{2686.73828125,835.8828125,19.081390380859},
{2560.8037109375,786.283203125,5.3157968521118},
{2571.9599609375,786.2587890625,10.954463005066},
{2559.4072265625,787.1552734375,10.954463005066},
{1727.9169921875,733.181640625,10.8203125},
{1723.525390625,707.7177734375,10.8203125},
{1664.3408203125,733.4111328125,10.8203125},
{1606.748046875,708.228515625,10.8203125},
{1606.783203125,729.6123046875,10.8203125},
{1038.689453125,1015.6962890625,11},
{1059.0615234375,1239.1982421875,10.827476501465},
{1060.6962890625,1277.2705078125,10.8203125},
{1042.611328125,1305.5810546875,10.8203125},
{939.115234375,1739.154296875,8.8515625},
{952.1171875,1769.9970703125,8.8515625},
{976.6630859375,2081,10.8203125},
{925.6767578125,2083.236328125,10.8203125},
{926.4384765625,2057.66796875,10.8203125},
{967.640625,2159.4072265625,10.8203125},
{1091.0048828125,2116.341796875,15.350400924683},
{1079.990234375,2132.2490234375,10.8203125},
{1085.25390625,2119.986328125,10.8203125},
{1063.5029296875,2079.5068359375,10.8203125},
{1125.619140625,2008.794921875,10.8203125},
{1125.2802734375,1985.640625,10.8203125},
{1085.5263671875,1911.3779296875,10.8203125},
{1111.28125,1914.15234375,10.8203125},
{1053.90234375,2252.34375,10.8203125},
{1025.453125,2268.9248046875,10.8203125},
{1103.5712890625,2326.3046875,10.8203125},
{1121.9013671875,2342.8671875,10.8203125},
{1153.9189453125,2341.7431640625,10.8203125},
{1070.7001953125,2170.1552734375,16.71875},
{2103.4658203125,2677.0498046875,10.812969207764},
{2108.1220703125,2652.4365234375,10.812969207764},
{2120.177734375,2655.0498046875,10.812969207764},
{2142.5478515625,2718.3193359375,10.8203125},
{2193.6806640625,2791.447265625,10.8203125},
{2198.767578125,2791.92578125,10.8203125},
{2214.35546875,2792.78515625,10.8203125},
{2207.486328125,2725.767578125,10.8203125},
{2263.376953125,2753.75,10.8203125},
{2263.515625,2778.1767578125,10.8203125},
{2289.6416015625,2783.9775390625,10.8203125},
{2291.798828125,2755.451171875,10.8203125},
{2291.7548828125,2739.0244140625,10.8203125},
{2315.318359375,2768.935546875,10.8203125},
{2335.0419921875,2786.3701171875,10.8203125},
{2343.5244140625,2766.2724609375,10.8203125},
{2358.9091796875,2774.96875,10.8203125},
{2420.7333984375,2780.388671875,10.8203125},
{2502.482421875,2777.712890625,10.8203125},
{2551.6826171875,2815.7275390625,10.8203125},
{2596.8330078125,2808.8125,11.015830993652},
{2613.2099609375,2810.5712890625,10.8203125},
{2608.689453125,2839.23046875,10.8203125},
{2624.767578125,2840.0634765625,10.8203125},
{2598.2841796875,2799.8720703125,10.8203125},
{2717.3310546875,2849.201171875,10.8203125},
{2737.30859375,2753.4443359375,10.8203125},
{2714.6796875,2673.611328125,10.8203125},
{2622.2392578125,2715.6875,36.538642883301},
{2662.0908203125,2676.90234375,10.8203125},
{2681.4990234375,2667.1689453125,10.8203125},
{2793.83984375,2530.25390625,11.0625},
{2905.978515625,2491.16796875,11.0625},
{2808.833984375,2019.7890625,10.8203125},
{2800.5009765625,2020.421875,10.812992095947},
{2808.4169921875,1986.646484375,10.8203125},
{2807.7001953125,1634.1181640625,10.8203125},
{2816.5810546875,1687.5234375,10.8203125},
{2823.9375,1634.9892578125,10.8203125},
{2832.07421875,1689.4052734375,10.8203125},
{2839.3994140625,1634.103515625,10.8203125},
{2847.9248046875,1689.35546875,10.8203125},
{2868.0625,1588.8525390625,10.8203125},
{2867.9873046875,1621.4189453125,10.8203125},
{2874.4990234375,1587.3759765625,10.8203125},
{2882.8896484375,1621.7314453125,10.8203125},
{2889.8212890625,1590.45703125,10.8203125},
{2899.5361328125,1620.791015625,10.8203125},
{2781.5419921875,1444.8740234375,10.696803092957},
{2856.9775390625,1284.5283203125,11.390625},
{2857.044921875,1308.8486328125,11.390625},
{2815.3505859375,1244.990234375,11.3125},
{2774.4541015625,1243.3193359375,11.3125},
{-1951.3173828125,1000.6396484375,35.175628662109},
{-1320.685546875,493.205078125,18.234375},
{-1479.3505859375,430,7.1875},
{-1422.6416015625,372.73046875,7.1875},
{-1465.4599609375,337.732421875,7.1875},
{-1728.029296875,181.03515625,3.5546875},
{-1691.2890625,-87.5361328125,3.5715780258179},
{-1197.2041015625,-130.8515625,14.1484375},
{-1233.2412109375,-86.5556640625,14.29193687439},
{-1816.6513671875,-180.69140625,9.3984375},
{-2084.64453125,-743.4033203125,32.171875},
{-2096.4130859375,-809.65234375,32.171875},
{-2067.6474609375,-860.0107421875,32.171875},
{-2079.0458984375,-925.1484375,32.171875},
{-2095.75390625,-966.0205078125,32.171875},
{-1964.25,-755.33984375,35.890884399414},
{-1945.4501953125,-806.0654296875,35.93962097168},
{-1964.26171875,-879.8671875,36.262706756592},
{-1945.1962890625,-911.0498046875,35.890884399414},
{-1963.6259765625,-959.3974609375,36.290878295898},
{-2520.646484375,-624.9404296875,132.78553771973},
{-2521.90625,-624.951171875,132.78158569336},
{-2535.2138671875,-688.673828125,139.3203125},
{-2505.955078125,-666.00390625,139.3203125},
{-1940.962890625,-1091.6123046875,32.175434112549},
{-1948.9638671875,-1091.5654296875,32.175434112549},
{-1437.4697265625,-964.10546875,201.05328369141},
{-1424.443359375,-967.3876953125,200.81311035156},
{-1181.90234375,-1133.8779296875,129.21875},
{-1184.7333984375,-1143.9267578125,129.21875},
{-993.9638671875,-700.7119140625,32.0078125},
{-1053.3310546875,-694.8388671875,32.3515625},
{-1103.5712890625,-752.294921875,32.0078125},
{-1115.271484375,-667.0048828125,32.0078125},
{-1067.7939453125,-597.3525390625,32.0078125},
{-576.1923828125,-538.9931640625,25.5234375},
{-529.0849609375,-539.048828125,25.5234375},
{-520.630859375,-506.4384765625,24.515340805054},
{-619.578125,-490.775390625,25.5234375},
{-395.06640625,-1148.8955078125,69.414436340332},
{-58.3115234375,-1112.5966796875,1.3712005615234},
{-69.4423828125,-1104.060546875,1.078125},
{-87.0576171875,-1212.1640625,2.890625},
{-90.9384765625,-1576.271484375,2.6171875},
{-263.8203125,-2183.5810546875,28.937950134277},
{-1971.6767578125,-2431.595703125,30.625},
{-1992.8837890625,-2388.359375,30.625},
{-2091.8896484375,-2260.0693359375,30.625},
{-2120.6064453125,-2296.5361328125,30.631944656372},
{-2198.0224609375,-2329.6279296875,30.625},
{-2183.4765625,-2430.1669921875,35.5234375},
{-2156.3916015625,-2552.9521484375,30.6171875},
{-2241.3623046875,-2479.634765625,31.216468811035},
{-2226.1494140625,-2400.462890625,31.984375},
{-2191.7451171875,-2432.1484375,31.484375},
{-2015.0400390625,-2395.818359375,30.625},
{-2816.2548828125,-1515.603515625,140.84375},
{-1830.9814453125,-1603.1318359375,23.015625},
{-1805.3876953125,-1602.94140625,23.015625},
{-1920.52734375,-1671.5361328125,23.015625},
{-1849.0419921875,-1604.025390625,21.7578125},
{-1846.5400390625,-1708.5849609375,41.113433837891},
{-1425.5751953125,-1553.6083984375,102.359375},
{-1467.59375,-1522.412109375,101.75132751465},
{-1632.8955078125,-2247.5673828125,31.4765625},
{-1119.7041015625,-1626.40234375,76.37393951416},
{-1112.24609375,-1677.064453125,76.3671875},
{-1079.4052734375,-1296.880859375,129.21875},
{-489.4853515625,-716.05078125,25.248840332031},
{-77.2392578125,-1136.3759765625,1.078125},
{1636.1298828125,-2237.677734375,13.506058692932},
{1572.5693359375,-2242.9287109375,-2.7005190849304},
{1568.48046875,-2333.177734375,-2.6844439506531},
{1792.9951171875,-2334.0615234375,-2.6847453117371},
{1806.4775390625,-2303.0615234375,-2.5784506797791},
{1598.80078125,-2639.578125,13.546875},
{1685.734375,-2638.685546875,13.601192474365},
{1757.38671875,-2640.12890625,13.624307632446},
{1898.04296875,-2640.3408203125,13.634287834167},
{-726.4716796875,-104.1103515625,68.285224914551},
{-435.5908203125,-59.4892578125,58.875},
{-107.7705078125,-219.7900390625,1.9970067739487},
{-121.533203125,-232.7431640625,1.421875},
{-155.19921875,-293.9130859375,3.9053149223328},
{-132.642578125,-313.8212890625,2.7646160125732},
{-114.1904296875,-314.3271484375,2.7646160125732},
{-84.361328125,-301.16015625,2.7646157741547},
{-49.3046875,-269.6494140625,6.633186340332},
{-11.07421875,-269.5751953125,5.4296875},
{32.3818359375,-290.8232421875,2.195987701416},
{84.34375,-314.5419921875,1.578125},
{93.677734375,-308.94921875,1.578125},
{90.53515625,-185.2373046875,1.484375},
{121.9404296875,-294.06640625,1.578125},
{79.8994140625,-179.513671875,1.5788015127182},
{151.1376953125,-300.646484375,1.578125},
{194.771484375,-225.9521484375,1.778618812561},
{220.5595703125,-233.78515625,1.778618812561},
{243.986328125,-47.2861328125,1.578125},
{321.0517578125,-44.62890625,1.5699377059937},
{331.26171875,-39.9609375,2.2255229949951},
{344.6259765625,-71.193359375,2.4308085441589},
{374.6015625,-76.740234375,1.3828125},
{105.8173828125,-189.13671875,1.5086135864258},
{312.5322265625,-153.5458984375,1.578125},
{308.158203125,-191.17578125,1.578125},
{303.169921875,-238.26953125,1.578125},
{162.3916015625,-43.6484375,1.578125},
{155.21484375,-21.7392578125,1.578125},
{159.08203125,-22.6591796875,1.578125},
{277.880859375,5.529296875,2.4217844009399},
{209.603515625,26.099609375,2.57080078125},
{214.177734375,22.1083984375,2.57080078125},
{202.302734375,-182.6708984375,1.578125},
{1206.623046875,174.1494140625,20.466976165771},
{1243.7236328125,216.51953125,19.5546875},
{1268.3505859375,232.5703125,25.048685073853},
{1254.826171875,241.130859375,19.5546875},
{1357.919921875,361.603515625,20.499504089355},
{1323.5478515625,286.693359375,20.045194625854},
{1199.2802734375,243.4189453125,19.5546875},
{1427.1650390625,270.5390625,19.5546875},
{1418.296875,221.408203125,19.561782836914},
{2321.544921875,-62.4482421875,26.484375},
{2318.248046875,-51.705078125,26.484375},
{2315.5703125,33.6708984375,27.473955154419},
{2324.9736328125,12.3369140625,26.484375},
{2315.2060546875,56.0517578125,26.481512069702},
{636.0791015625,-499.974609375,16.3359375},
{710.0751953125,-569.740234375,16.3359375},
{812.3603515625,-562.751953125,16.3359375},
{843.13671875,-603.37109375,18.421875},
{797.4208984375,-620.9560546875,16.3359375},
{725.626953125,-469.60546875,16.3359375},
{684.79296875,-444.8583984375,16.3359375},
{1579.150390625,-1413.5146484375,13.546875},
{1702.2421875,-1469.3564453125,13.546875},
{1580.3486328125,-1634.7626953125,13.561421394348},
{1611.162109375,-1720.8974609375,6.21875},
{1291.7822265625,-1253.8310546875,13.546875},
{1297.7333984375,-1254.0087890625,13.546875},
{1319.7333984375,-1241.2666015625,13.546875},
{1122.3857421875,-1334.6923828125,12.765430450439},
{1112.900390625,-1334.5439453125,12.777824401855},
{1095.501953125,-1333.6240234375,12.854690551758},
{1084.4580078125,-1223.2919921875,15.8203125},
{1107.0908203125,-1180.970703125,18.788990020752},
{1702.1064453125,913.7470703125,10.8203125},
{1732.7607421875,987.923828125,10.8203125},
{1629.96875,962.341796875,10.808609962463},
{1630.2109375,976.7177734375,10.8203125},
{1624.7265625,1039.009765625,10.8203125},
{1641.337890625,1074.083984375,10.8203125},
{1707.5380859375,1074.3359375,10.8203125},
{1612.294921875,915.7236328125,10.694253921509},
{1524.279296875,1009.5546875,10.8203125},
{1466.189453125,1067.859375,10.007030487061},
{1468.21875,1039.86328125,10.176633834839},
{1451.1953125,972.626953125,10.113735198975},
{1407.1533203125,969.900390625,10.812976837158},
{1404.8310546875,1147.681640625,10.8203125},
{1354.0390625,1153.826171875,10.8203125},
{1357.412109375,1043.3046875,10.8203125},
{1317.8544921875,1252.9453125,14.273136138916},
{1267.9306640625,1335.9736328125,10.812978744507},
{1269.349609375,1372.19140625,10.8203125},
{1304.330078125,1612.9052734375,10.8203125},
{1340.673828125,1701.0634765625,10.8203125},
{1345.853515625,1751.7734375,10.8203125},
{1595.265625,1449.966796875,10.828193664551},
{1567.91796875,1152.4404296875,10.8125},
{1588.4033203125,1152.64453125,10.805154800415},
{1667.9609375,1327.03515625,10.76210975647},
{1653.267578125,1687.5673828125,10.8203125},
{1661.232421875,1699.3662109375,10.8203125},
{1716.154296875,1616.421875,10.04080581665},
{1734.1572265625,1168.533203125,10.8203125},
{1714.0908203125,1161.8291015625,10.785179138184},
{1679.5263671875,1165.91796875,10.8203125},
{1715.9091796875,1314.2109375,10.8203125},
{1684.2109375,1849.6982421875,10.8203125},
{1723.640625,2026.0478515625,10.8203125},
{1311.5478515625,2085.80859375,10.8203125},
{1490.9951171875,2364.2392578125,10.8203125},
{1515.6279296875,2364.55078125,10.8203125},
{1642.16015625,2338.59765625,9.9275417327881},
{1678.6640625,2340.228515625,10.005611419678},
{1677.1953125,2312.1484375,9.8829164505005},
{1658.9814453125,2200.345703125,10.8203125},
{1751.7412109375,2233.44140625,10.8203125},
{1751.6025390625,2202.806640625,10.8203125},
{1914.9599609375,1988.7490234375,7.5945882797241},
{1856.3515625,1979.90234375,7.5950384140015},
{1913.951171875,1931.6240234375,13.784772872925},
{1932.2236328125,1816.25390625,12.714401245117},
{1915.0048828125,1727.3134765625,12.714403152466},
{2016.1767578125,1751.3125,12.77968120575},
{1947.13671875,2070.68359375,10.8203125},
{2008.15234375,2224.7578125,11.185302734375},
{1983.005859375,2262.955078125,20.525520324707},
{2063.337890625,2239.943359375,10.114772796631},
{2185.8486328125,2503.96484375,10.8203125},
{2117.591796875,2416.0634765625,36.6171875},
{2098.9580078125,2420.9765625,74.578598022461},
{2174.9921875,961.966796875,10.8203125},
{2379.8017578125,1041.314453125,10.8203125},
{2497.515625,1213.3046875,10.8203125},
{2588.2197265625,1202.5556640625,10.8203125},
{2599.9150390625,1267.041015625,10.8203125},
{2230.4013671875,1431.62109375,11.0546875},
{2297.9111328125,1458.0966796875,36.421875},
{2609.7099609375,1437.61328125,10.8203125},
{2609.2578125,1437.6875,10.8203125},
{2407.87890625,1723.3291015625,10.8203125},
{2477.8564453125,1761.0068359375,10.8203125},
{2466.38671875,1762.009765625,10.8203125},
{2454.20703125,1761.912109375,10.8203125},
{2351.79296875,1882.0380859375,10.671875},
{2220.0244140625,1979.2744140625,9.8671274185181},
{2277.4658203125,1969.9189453125,15.5703125},
{2297.9990234375,1981.5712890625,20.822093963623},
{2298.341796875,1980.94140625,26.299333572388},
{2277.263671875,1944.7265625,32.0078125},
{2515.4912109375,2321.9970703125,10.8203125},
{2295.2236328125,2440.34765625,10.8203125},
{2295.6240234375,2477.6123046875,10.8203125},
{1033.5419921875,-1116.2109375,23.893451690674},
{1011.9638671875,-1116.595703125,23.898933410645},
{901.11328125,-1202.6923828125,16.983215332031},
{836.623046875,-1203.15625,16.9765625},
{861.3544921875,-1256.3896484375,14.760587692261},
{846.0087890625,-1292.974609375,13.652151107788},
{910.306640625,-1235.380859375,17.218402862549},
{915.8447265625,-1235.5244140625,17.2109375},
{979.2724609375,-1254.681640625,16.946468353271},
{1031.8544921875,-1448.833984375,13.554634094238},
{1005.0517578125,-1463.7822265625,13.555473327637},
{855.6826171875,-1360.052734375,13.745624542236},
{858.552734375,-1422.9619140625,12.336584091187},
{992.896484375,-1521.701171875,13.552418708801},
{733.05078125,-1359.1865234375,23.579231262207},
{732.6806640625,-1335.3681640625,13.538493156433},
{435.0791015625,-1361.904296875,14.809816360474},
{438.4423828125,-1360.453125,14.816032409668},
{442.7666015625,-1355.5517578125,14.82363986969},
{564.359375,-1293.5673828125,17.248237609863},
},
["residential"] = {

{-2105.1796875,659.5048828125,52.476016998291},
{-2122.7890625,660.1171875,52.494960784912},
{-2161.1806640625,660.69140625,52.440773010254},
{-2156.9794921875,715.134765625,69.5625},
{-2540.779296875,831.962890625,52.09375},
{-2543.5556640625,922.765625,67.09375},
{-2553.427734375,985.7685546875,78.2734375},
{-2719.1953125,-318.9580078125,7.84375},
{-2791.75,-160.4765625,10.0546875},
{-2784.1376953125,-99.5029296875,10.0546875},
{-2730.771484375,-174.17578125,7.203125},
{-2677.7392578125,-179.662109375,4.328125},
{-2689.53125,-141.2802734375,7.203125},
{-2723.15234375,-113.3740234375,7.203125},
{-2632.52734375,-108.0048828125,4.328125},
{-2679.94140625,-155.75,4.328125},
{-2632.181640625,-191.0283203125,7.203125},
{-2619.455078125,-153.2880859375,4.3359375},
{-2590.529296875,-106.01953125,4.3296241760254},
{-2733.2177734375,-109.572265625,4.328125},
{-2782.1259765625,-148.6162109375,7.1872329711914},
{-2791.7412109375,-24.3642578125,10.0546875},
{2416.958984375,-2454.0576171875,13.640612602234},
{-2781.07421875,-26.6162109375,7.3766598701477},
{-2734.8994140625,-53.6279296875,4.3354206085205},
{-2731.0927734375,-12.6806640625,7.203125},
{-2725.55078125,-36.1650390625,7.1953125},
{-2724.6787109375,-57.98828125,4.3425788879395},
{-2781.7265625,21.095703125,7.1796875},
{-2734.1474609375,25.7275390625,4.3353595733643},
{-2790.44921875,7.244140625,7.1953125},
{-2723.0166015625,21.908203125,7.203125},
{-2664.251953125,-8.732421875,6.1328125},
{-2718.8681640625,52.302734375,4.3359375},
{-2689.376953125,74.5224609375,7.203125},
{2273.20703125,-2371.5419921875,17.421871185303},
{-2686.9892578125,115.25,7.1953125},
{-2677.7412109375,132.431640625,4.335750579834},
{-2681.5703125,91.333984375,7.203125},
{-2679.9130859375,68.3857421875,4.328125},
{2447.8544921875,-2209.4921875,26.6328125},
{-2631.6923828125,57.8232421875,4.328125},
{-2631.8662109375,105.4345703125,4.5250973701477},
{-2620.9384765625,120.8359375,7.203125},
{-2622.375,71.7958984375,4.3359375},
{-2619.466796875,57.779296875,4.3359375},
{-2620.7958984375,103.37890625,7.203125},
{-2791.6767578125,77.447265625,10.0546875},
{-2791.6845703125,103.6552734375,10.0546875},
{-2791.6201171875,130.3515625,7.859375},
{-2783.59765625,138.4697265625,10.0546875},
{-2781.361328125,91.9453125,7.1796875},
{-2783.810546875,189.72265625,10.0546875},
{-2780.9443359375,210.013671875,7.3766598701477},
{-2791.7958984375,212.0029296875,10.0546875},
{-2789.4150390625,183.896484375,10.0625},
{-2720.626953125,127.52734375,7.0390625},
{-2689.21484375,96.3095703125,7.203125},
{-2760.80078125,142.8271484375,7.03125},
{-2632.37890625,274.76953125,4.3347663879395},
{-2624.2607421875,250.9365234375,4.5094723701477},
{-2654.486328125,200.240234375,5},
{-2678.177734375,200.3193359375,7.1953125},
{-2683.3466796875,192.1875,7.1953125},
{-2654.3681640625,190.7880859375,4.328125},
{-2627.869140625,179.1484375,4.3401975631714},
{-2621.79296875,168.8271484375,7.1953125},
{2529.234375,-2250.3193359375,3},
{-2649.146484375,376.1025390625,6.1592502593994},
{-2766.4765625,375.21875,6.3346824645996},
{-2729.5869140625,351.921875,4.7109375},
{-2620.99609375,-185.7578125,7.203125},
{-2558.9501953125,-199.0283203125,10.887868881226},
{-2515.1201171875,-172.2314453125,25.078411102295},
{-2541.33203125,-145.84765625,15.688335418701},
{-2524.0888671875,-79.9541015625,21.780969619751},
{2138.8505859375,-2292.7666015625,14.780059814453},
{2122.322265625,-2268.7783203125,20.671875},
{2229.953125,-2286.5478515625,14.375131607056},
{-2538.826171875,44.474609375,8.608250617981},
{2226.75,-2262.5888671875,13.554685592651},
{-2507.6923828125,51.005859375,25.623983383179},
{-2588.2236328125,59.15625,4.3359375},
{-2591.5322265625,170.0634765625,4.6730613708496},
{-2577.947265625,104.255859375,4.3359375},
{-2545.4833984375,193.333984375,13.0390625},
{2021.88671875,-2067.1806640625,17.357158660889},
{2043.19140625,-2124.6103515625,13.6328125},
{-2454.6328125,-135.880859375,26.191104888916},
{1926.3515625,-2127.6796875,13.579386711121},
{-2432.1279296875,-182.7470703125,35.3125},
{-2431.5146484375,-109.6416015625,35.3203125},
{-2430.8583984375,9.8046875,35.318264007568},
{1990.486328125,-1998.98046875,13.546875},
{1940.0703125,-2038.7099609375,13.546875},
{1936.3857421875,-1983.3828125,13.546875},
{-2545.384765625,118.939453125,22.140625},
{-2488.7578125,130.7890625,25.8671875},
{-2463.4296875,131.7529296875,35.171875},
{2201.9130859375,-1971.7041015625,13.78413105011},
{-2548.392578125,194.8271484375,6.2325587272644},
{-2579.7734375,309.8671875,5.1796875},
{2280.111328125,-2046.1591796875,13.546875},
{-2571.2275390625,246.6923828125,10.380719184875},
{-2622.861328125,375.8916015625,6.1592502593994},
{-2594.951171875,458.486328125,14.609375},
{2431.83203125,-2137.091796875,13.546875},
{2527.3076171875,-2129.2861328125,13.546875},
{-2425.6650390625,338.533203125,36.99991607666},
{-2228.8994140625,253.7900390625,35.3203125},
{-2183.375,199.9150390625,35.3203125},
{-2219.51171875,100.3720703125,35.3203125},
{1951.85546875,-2187.693359375,13.546875},
{-2200.306640625,-79.642578125,35.3203125},
{-2218.875,-180.6923828125,35.365856170654},
{-2270.1845703125,-156.142578125,35.3203125},
{1083.7578125,-2033.1240234375,69.0078125},
{1122.390625,-2043.921875,74.4296875},
{1121.125,-2007.8056640625,74.4296875},
{1815.701171875,-1976.759765625,13.546875},
{1831.8251953125,-1996.826171875,13.546875},
{1731.6982421875,-2055.0126953125,13.572721481323},
{1673.8896484375,-2122.5712890625,14.146014213562},
{1694.28515625,-2082.1337890625,13.546875},
{1714.8828125,-2125.41015625,14.056648254395},
{1762.29296875,-2102.0341796875,13.856951713562},
{1804.908203125,-2141.689453125,13.546875},
{1846.451171875,-2021.099609375,13.546875},
{1863.1640625,-2019.9775390625,13.546875},
{1858.8203125,-2080.7197265625,15.03125},
{1870.9697265625,-2020.482421875,13.546875},
{1899.0322265625,-1997.6650390625,13.546875},
{1920.576171875,-2086.7236328125,13.577843666077},
{-2177.2421875,10.7216796875,35.3203125},
{-2027.69140625,-40.7685546875,38.8046875},
{1846.9462890625,-2116.369140625,15.170427322388},
{1894.630859375,-2133.23046875,15.466326713562},
{-2171.7919921875,250.6259765625,35.336006164551},
{2333.375,-1943.3095703125,14.96875},
{-2242.1787109375,122.328125,35.3203125},
{2387.0634765625,-1941.490234375,13.546875},
{-2265.8994140625,33.01953125,35.3203125},
{-2287.04296875,-79.845703125,35.3203125},
{-2313.0947265625,-11.6533203125,35.3203125},
{2437.9951171875,-2020.248046875,13.902541160583},
{2515.3583984375,-2027.7763671875,13.546875},
{2526.203125,-2000.7529296875,13.78261089325},
{-1968.5322265625,110.001953125,27.6875},
{-2025.8759765625,-101.044921875,35.1640625},
{2635.2255859375,-1993.6181640625,13.993547439575},
{2660.84375,-1984.49609375,13.550971984863},
{2673.8603515625,-2020.2509765625,14.168166160583},
{-2080.7451171875,-407.314453125,38.734375},
{-1993.1416015625,-443.4228515625,38.734375},
{2786.7822265625,-1922.8232421875,17.3203125},
{2751.5166015625,-1950.9462890625,13.546875},
{2736.0234375,-1974.9482421875,13.546034812927},
{2728.2529296875,-1919.462890625,13.539363861084},
{-1709.1103515625,406.3779296875,7.4189829826355},
{-1923.2841796875,433.2978515625,35.254241943359},
{2333.525390625,-1883.5400390625,15},
{2332.294921875,-1922.615234375,12.300741195679},
{-2054.3359375,457.095703125,35.300045013428},
{2296.49609375,-1883.05078125,14.234375},
{2261.166015625,-1906.74609375,14.9375},
{-2106.7265625,338.134765625,35.171875},
{-2214.21875,493.427734375,35.171875},
{-2093.103515625,513.841796875,35.171875},
{-1940.0380859375,555.080078125,35.171875},
{-1807.3115234375,531.25390625,35.539566040039},
{-1605.6103515625,710.2880859375,13.8671875},
{1869.5263671875,-1913.0859375,15.256797790527},
{1850.52734375,-1914.865234375,15.256797790527},
{1847.662109375,-1870.5869140625,13.578125},
{1789.375,-1871.720703125,13.564960479736},
{-1729.24609375,650.0126953125,25.110088348389},
{-1929.267578125,639.1357421875,46.5625},
{-1619.111328125,867.921875,7.6953125},
{-1493.103515625,886.2890625,7.1875},
{-1447.17578125,919.0634765625,7.1875},
{-1703.9638671875,785.5986328125,25.736047744751},
{-1749.3125,873.0576171875,25.0859375},
{1488.2373046875,-1911.6669921875,24.190805435181},
{1438.9794921875,-1918.8115234375,24.416709899902},
{-1786.2587890625,772.7470703125,24.890625},
{1453.3564453125,-1885.36328125,23.1484375},
{-1967.392578125,743.8095703125,45.4453125},
{-2099.3818359375,602.53125,45.096294403076},
{1489.544921875,-1847.30078125,13.546875},
{1450.00390625,-1848.8515625,13.96875},
{1470.18359375,-1770.9287109375,18.795755386353},
{1493.5146484375,-1772.1767578125,18.795755386353},
{-2208.333984375,695.2158203125,49.4375},
{1338.7646484375,-1777.2900390625,13.538893699646},
{1378.732421875,-1753.1376953125,14.140625},
{1352.4580078125,-1758.0810546875,13.5078125},
{1337.400390625,-1819.83203125,13.550866127014},
{1213.8720703125,-1815.3349609375,16.59375},
{1212.9775390625,-1811.822265625,16.59375},
{1209.6083984375,-1751.4228515625,13.593654632568},
{-2800.16015625,374.880859375,6.3359375},
{1144.279296875,-1765.66796875,13.612593650818},
{1170.3505859375,-1862.4501953125,13.772918701172},
{-2456.1337890625,504.0732421875,30.078125},
{-2347.4150390625,495.97265625,30.641031265259},
{1020.33984375,-1901.1484375,12.666422843933},
{-2280.0615234375,654.4853515625,49.4453125},
{984.8310546875,-1830.962890625,13.333910942078},
{-2368.8896484375,711.55078125,35.17308807373},
{960.322265625,-1823.7724609375,13.328245162964},
{-2213.8408203125,720.77734375,49.40625},
{-2168.5458984375,821.1298828125,64.973213195801},
{791.4951171875,-1753.921875,13.443346977234},
{768.275390625,-1745.72265625,13.077295303345},
{718.2763671875,-1783.91015625,13.6328125},
{572.25,-1765.8583984375,14.398722648621},
{-2340.1103515625,796.7646484375,41.989013671875},
{568.712890625,-1762.2470703125,5.8157567977905},
{-2447.6240234375,821.5927734375,35.1796875},
{-2541.2744140625,733.4091796875,28.056119918823},
{-2661.5478515625,722.1953125,27.961761474609},
{499.326171875,-1870.8916015625,4.6769704818726},
{-2864.9677734375,681.51953125,23.460912704468},
{674.787109375,-1867.716796875,5.4609375},
{-2888.5,794.6943359375,35.03125},
{-2868.1318359375,836.2431640625,39.5078125},
{-2840.15234375,884.6396484375,44.0546875},
{-2844.4931640625,921.5751953125,44.0546875},
{399.6533203125,-2068.6455078125,10.745077133179},
{-2866.0341796875,957.32421875,44.0546875},
{400.513671875,-2065.7412109375,10.748622894287},
{361.294921875,-2072.01171875,10.6953125},
{-2907.2626953125,1026.990234375,36.828125},
{-2900.716796875,1080.826171875,32.1328125},
{-2905.2587890625,1171.9189453125,13.6640625},
{314.0048828125,-1771.341796875,4.6501817703247},
{290.4140625,-1764.025390625,4.546875},
{171.2255859375,-1769.328125,4.4670028686523},
{160.7001953125,-1766.35546875,6.796875},
{-2738.3203125,746.625,49.189296722412},
{-2738.578125,801.5126953125,53.0625},
{-2651.9990234375,826.8935546875,49.984375},
{-2687.60546875,803.1123046875,49.9765625},
{-2652.7548828125,731.8720703125,27.957878112793},
{-2656.0595703125,695.287109375,27.935955047607},
{-2638.3505859375,728.234375,27.965827941895},
{-2640.048828125,730.693359375,30.075717926025},
{-2622.501953125,783.1640625,44.859375},
{1780.7333984375,-1705.94140625,13.5234375},
{1699.734375,-1665.74609375,20.205995559692},
{-2620.67578125,855.5283203125,53.568695068359},
{-2657.369140625,848.6103515625,64.0078125},
{-2653.2548828125,851.5947265625,64.014892578125},
{2018.19921875,-1703.623046875,14.234375},
{-2580.666015625,920.36328125,64.984375},
{-2542.490234375,943.21875,64},
{-2511.763671875,1020.671875,77.212951660156},
{-2572.8955078125,1155.013671875,55.734909057617},
{-2523.896484375,1142.6962890625,55.7265625},
{-2486.3193359375,1141.9541015625,55.7265625},
{-2430.7255859375,1140.1650390625,55.7265625},
{-2385.4306640625,1135.0029296875,55.7265625},
{-2534.14453125,1150.4560546875,55.606960296631},
{-2512.5712890625,1046.0087890625,65.512168884277},
{-2576.6865234375,992.35546875,78.2734375},
{-2648.087890625,952.1796875,71.959915161133},
{-2641.10546875,935.6025390625,72.445816040039},
{-2670.79296875,927.869140625,79.703125},
{-2719.208984375,917.32421875,67.600875854492},
{-2711.130859375,968.6748046875,54.4609375},
{-2737.0263671875,846.4697265625,59.27278137207},
{-2620.1806640625,833.017578125,52.09375},
{-2593.2373046875,883.4677734375,63.25},
{-2413.0849609375,920.875,45.495388031006},
{-2369.90625,846.65234375,43.7890625},
{-2370.494140625,770.8046875,35.045497894287},
{-2309.7568359375,720.7900390625,49.4140625},
{-1706.255859375,29.8837890625,3.5546875},
{-2017.7783203125,331.3955078125,35.171875},
{-2627.091796875,2319.1240234375,8.3104915618896},
{-2627.53125,2310.21484375,8.3140296936035},
{-2639.546875,2349.1591796875,8.4840850830078},
{-2159.2314453125,753.7568359375,69.514846801758},
{-2118.1787109375,795.80078125,69.568389892578},
{-2056.2685546875,820.6025390625,60.074989318848},
{-1947.0849609375,790.0537109375,55.724136352539},
{-1956.5302734375,766.6357421875,55.725494384766},
{-1986.2353515625,660.1337890625,46.568286895752},
{-1917.0634765625,671.431640625,46.5625},
{-2291.9345703125,2282.28125,4.9792766571045},
{-1880.5390625,822.62890625,35.177783966064},
{-1951.2939453125,883.7041015625,38.50732421875},
{-1953.09765625,824.728515625,42.5234375},
{-2046.8876953125,896.4609375,53.115028381348},
{-2099.5439453125,897.380859375,76.7109375},
{-2116.9609375,927.802734375,86.079063415527},
{-2159.5185546875,983.771484375,80},
{-2041.9365234375,1020.5859375,54.677085876465},
{-2017.599609375,984.314453125,47.962516784668},
{-2126.052734375,832.546875,69.5625},
{-2223.42578125,795.779296875,49.434646606445},
{-2285.2978515625,829.1748046875,57.170230865479},
{-2234.142578125,888.5244140625,66.652717590332},
{-2294.791015625,969.9736328125,65.334289550781},
{-2333.3525390625,943.3544921875,53.981349945068},
{-2448.248046875,972.8310546875,45.296875},
{1097.2744140625,-1829.2568359375,16.59375},
{-2351.78125,1226.12109375,33.065242767334},
{-2383.1181640625,1262.92578125,26.330062866211},
{-2383.13671875,1337.3291015625,12.704105377197},
{-2433.76171875,1247.7568359375,33.543380737305},
{-2477.1708984375,1287.291015625,22.71538734436},
{-2433.0810546875,1338.123046875,8.5078125},
{-2598.787109375,2357.36328125,9.8829956054688},
{-2597.97265625,2364.6982421875,9.8829956054688},
{-2624.841796875,1412.529296875,7.09375},
{-2582.083984375,2300.3154296875,7.0028858184814},
{-2582.58984375,2306.712890625,7.0028858184814},
{945.75,-1742.5810546875,13.554628372192},
{-2662.4541015625,1423.625,23.8984375},
{-2473.466796875,2404.85546875,16.666370391846},
{-2467.2998046875,2409.001953125,16.666431427002},
{-2660.6474609375,1423.822265625,23.8984375},
{-2558.138671875,2261.3583984375,5.0616064071655},
{-2518.8916015625,2236.94140625,5.1875},
{-2510.9248046875,1053.482421875,65.184410095215},
{-2564.291015625,992.2587890625,78.2734375},
{-2503.2177734375,2366.169921875,4.9801826477051},
{-2655.0634765625,985.83203125,64.991287231445},
{952.8359375,-1750.529296875,16.09974861145},
{-2707.033203125,864.4609375,70.703125},
{-2708.3837890625,852.9736328125,70.703125},
{-2737.572265625,866.14453125,64.6328125},
{1083.5673828125,-1697.2802734375,13.546875},
{-2706.9921875,722.8583984375,37.5390625},
{793.9755859375,-1700.279296875,14.033567428589},
{-2428.388671875,2368.30078125,5.4436712265015},
{794.951171875,-1687.7119140625,14.463310241699},
{-2372.560546875,614.0341796875,30.939836502075},
{782.015625,-1661.9453125,13.43461894989},
{-2325.4052734375,579.8740234375,30.298212051392},
{-2386.3583984375,2398.0888671875,8.8520927429199},
{768.0849609375,-1702.7763671875,5.1507549285889},
{-2217.0009765625,577.939453125,35.171875},
{-2379.6025390625,2443.66796875,10.169355392456},
{-2386.43359375,2446.5810546875,10.169355392456},
{-2188.6455078125,602.9736328125,35.1640625},
{-2193.0634765625,647.4208984375,49.4375},
{-2472.556640625,2450.2431640625,17.323022842407},
{-2478.9404296875,2449.1982421875,17.323022842407},
{-2479.0146484375,2488.603515625,18.229986190796},
{-2128.3837890625,619.0263671875,51.888767242432},
{693.546875,-1698.849609375,3.8148174285889},
{-2446.072265625,2513.0029296875,15.700329780579},
{694.7978515625,-1686.05859375,4.3461227416992},
{-2093.90234375,746.4248046875,69.5625},
{-2066.4052734375,755.412109375,71.890625},
{-2048.7001953125,755.439453125,64.15625},
{653.0830078125,-1719.681640625,14.760129928589},
{-2047.9453125,786.7783203125,64.15625},
{-2066.3515625,786.7685546875,71.890625},
{850.7080078125,-1688.8798828125,14.9397315979},
{851.0283203125,-1718.9765625,14.945223808289},
{-2018.3974609375,784.58203125,45.4453125},
{-2188.8427734375,2412.421875,5.15625},
{-2016.20703125,897.4267578125,45.4453125},
{890.72265625,-1637.328125,14.9296875},
{862.80078125,-1637.8037109375,14.942176818848},
{-1851.595703125,988.52734375,35.373413085938},
{936.6318359375,-1613.9462890625,14.951719284058},
{961.986328125,-1612.642578125,14.942341804504},
{-1874.517578125,1002.9794921875,37.778400421143},
{986.544921875,-1623.6884765625,14.9296875},
{-1589.71875,2706.115234375,56.176181793213},
{-1988.4599609375,1038.865234375,55.7265625},
{-1603.8671875,2689.3701171875,55.285556793213},
{982.1689453125,-1702.234375,14.964391708374},
{-1550.9228515625,2699.6728515625,56.269931793213},
{-2113.25390625,1042.162109375,71.52188873291},
{-1569.30078125,2629.9853515625,55.840278625488},
{954.8623046875,-1586.669921875,13.546875},
{982.9990234375,-1613.4287109375,13.517053604126},
{-2140.29296875,1190.37890625,55.7265625},
{-1670.7763671875,2545.4189453125,85.322410583496},
{-2065.986328125,1159.828125,46.6484375},
{-1667.3193359375,2486.291015625,87.172271728516},
{-2036.5498046875,1197.66015625,46.234375},
{-1939.35546875,1227.6513671875,31.647394180298},
{-2061.77734375,1232.759765625,31.436279296875},
{-1482.40625,2702.3271484375,56.254306793213},
{-1466.345703125,2692.7568359375,56.269931793213},
{-1450.88671875,2690.876953125,56.176181793213},
{-2152.6787109375,1248.7138671875,25.723867416382},
{-2280.8388671875,1149.1005859375,61.609375},
{-2238.50390625,1135.62890625,67.244506835938},
{-2282.4140625,1070.03515625,81.70255279541},
{-2239.7451171875,1037.275390625,83.849937438965},
{-2238.796875,962.17578125,66.652183532715},
{1182.35546875,-1635.0908203125,13.953125},
{1165.14453125,-1648.408203125,14},
{1208.0810546875,-1644.49609375,13.551703453064},
{1230.158203125,-1610.78125,13.546875},
{1286.142578125,-1583.453125,13.546875},
{-2282.498046875,916.9443359375,66.6484375},
{1258.1455078125,-1583.8603515625,13.546875},
{1241.8994140625,-1582.005859375,13.487106323242},
{-2210.7080078125,934.3779296875,69.044372558594},
{1216.8056640625,-1582.8935546875,13.546875},
{1184.6748046875,-1583.1826171875,13.553085327148},
{-2174.1484375,902.669921875,80.0078125},
{-2126.4375,1050.2275390625,80.0078125},
{-2190.4404296875,1080.2470703125,80.0078125},
{-2197.0576171875,1065.8515625,55.851322174072},
{-1989.88671875,1118.2568359375,54.46875},
{-1992.2333984375,1109.5595703125,53.215702056885},
{1286.8515625,-1625.6796875,13.546875},
{-1848.119140625,1082.5380859375,46.082084655762},
{1213.7568359375,-1638.6787109375,11.796875},
{-1836.1298828125,1054.5283203125,46.078125},
{1215.1533203125,-1676.26953125,11.796875},
{1215.4697265625,-1671.5966796875,11.796875},
{1265.119140625,-1676.375,13.546875},
{-1780.2353515625,1025.720703125,25.313758850098},
{-1806.322265625,979.560546875,24.890625},
{-1715.82421875,1017.95703125,17.917835235596},
{-1707.888671875,1018.419921875,17.917835235596},
{-1758.0185546875,963.916015625,24.897708892822},
{-1750.4970703125,964.119140625,24.890625},
{-1749.173828125,900.390625,25.0859375},
{-1810.5966796875,902.7138671875,24.996131896973},
{-1319.9130859375,2704.384765625,50.26628112793},
{-1697.5947265625,885.3671875,25.085273742676},
{-1694.443359375,951.7783203125,24.890625},
{-1701.66015625,1083.7275390625,45.364379882812},
{-1445.013671875,2652.4765625,56.269931793213},
{-1685.2197265625,1042.7490234375,54.703125},
{-1692.5009765625,1041.966796875,56.90625},
{-1459.5888671875,2653.4716796875,55.8359375},
{-1445.625,2636.2998046875,56.254306793213},
{-1429.990234375,2583.6455078125,56.887584686279},
{-1728.296875,1138.4921875,38.603340148926},
{-1658.23046875,1208.2958984375,7.25},
{-1657.8486328125,1206.876953125,13.671875},
{-1683.8203125,1209.6943359375,21.15625},
{-1651.9228515625,1203.73046875,13.671875},
{-1549.92578125,1169.955078125,7.1875},
{-1518.9580078125,1143.3271484375,7.1875},
{-1519.568359375,2609.55859375,55.8359375},
{-1466.28125,2610.453125,55.8359375},
{-1681.125,1350.302734375,7.1721897125244},
{-1677.6015625,1353.677734375,9.8046875},
{-1663.9833984375,1406.296875,7.1796875},
{-1629.1533203125,1388.310546875,7.1875},
{-1670.7919921875,1339.8427734375,7.1875},
{-1653.3564453125,1354.69921875,7.1859359741211},
{-1513.2900390625,2645.880859375,56.176181793213},
{-1783.3994140625,1537.8251953125,7.1875},
{-1891.443359375,1447.9384765625,7.1848773956299},
{-1956.7509765625,1345.25390625,7.1875},
{-1929.7412109375,1374.978515625,7.1875},
{-2043.798828125,1261.5126953125,9.1895523071289},
{-1294.099609375,2524.6044921875,87.476791381836},
{-1292.0693359375,2514.833984375,87.092361450195},
{-1321.5791015625,2506.8232421875,89.5703125},
{-1883.720703125,1299.7607421875,7.1796875},
{-1844.009765625,1332.70703125,7.1796875},
{-1798.103515625,1341.697265625,7.1796875},
{-1756.755859375,1320.3828125,7.1875},
{-1305.3330078125,2547.935546875,90.328125},
{-1739.32421875,1304.216796875,7.1875},
{-1711.357421875,1231.705078125,17.923469543457},
{-1901.9736328125,1239.8623046875,26.131290435791},
{-1643.0888671875,1172.935546875,7.1875},
{-1774.6650390625,1113.638671875,45.4453125},
{-1799.974609375,1206.595703125,25.125},
{-1852.4931640625,1162.2333984375,40.940418243408},
{-1901.9619140625,1222.646484375,33.744285583496},
{-1929.982421875,1190.52734375,45.4453125},
{-1997.3837890625,1190.546875,45.4453125},
{-2189.0498046875,1163.9794921875,55.7265625},
{-2238.091796875,1190.7646484375,55.725227355957},
{-2238.314453125,1154.1728515625,59.692321777344},
{-2297.9453125,1096.3759765625,79.853385925293},
{-2281.9619140625,979.47265625,70.926986694336},
{-2238.888671875,944.02734375,66.652183532715},
{-2168.71875,743.857421875,64.96125793457},
{-2128.3828125,690.29296875,65.523544311523},
{-2279.830078125,587.888671875,37.236404418945},
{-2339.8828125,679.787109375,38.392864227295},
{-2158.6142578125,888.83203125,80.0078125},
{-2129.673828125,943.015625,80},
{-2124.7880859375,1104.759765625,79.541061401367},
{-2054.5107421875,1194.177734375,45.457427978516},
{-1828.90234375,1338.880859375,7.1796875},
{-1693.0576171875,1249.966796875,7.189022064209},
{2744.8359375,-2014.96875,13.5546875},
{2801.4306640625,-1947.8447265625,17.3203125},
{2763.845703125,-1823.1318359375,11.846822738647},
{2804.529296875,-1774.9765625,11.84375},
{2795.94140625,-1723.66796875,11.84375},
{2674.6962890625,-1787.2060546875,11.84375},
{2813.078125,-1644.232421875,10.883123397827},
{2811.95703125,-1637.833984375,10.94800567627},
{2821.515625,-1603.890625,11.084532737732},
{2852.095703125,-1523.9375,11.153960227966},
{2795.5498046875,-1539.826171875,10.921875},
{2757.943359375,-1515.923828125,28.598701477051},
{2683.8037109375,-1540.4609375,26.087358474731},
{2668.0068359375,-1457.427734375,30.540340423584},
{2764.3232421875,-1476.1640625,30.453125},
{2751.1396484375,-1421.7392578125,32.046253204346},
{2753.732421875,-1419.1005859375,39.3664894104},
{2754.2275390625,-1384.1318359375,39.372711181641},
{2773.6650390625,-1402.2998046875,24.7421875},
{2710.2939453125,-1421.623046875,16.25},
{2862.7451171875,-1441.4228515625,10.942241668701},
{2792.15625,-1465.6298828125,40.0625},
{2818.7421875,-1466.765625,32.125},
{2794.216796875,-1427.798828125,20.21875},
{2613.7705078125,-1394.43359375,34.931190490723},
{2592.8203125,-1324.166015625,39.12483215332},
{2590.294921875,-1321.5458984375,39.894317626953},
{2752.2744140625,-1324.013671875,50},
{2755.447265625,-1301.8134765625,53.09375},
{2812.46875,-1287.7197265625,42.216262817383},
{2780.1640625,-1289.623046875,42.632743835449},
{2783.5634765625,-1333.5498046875,32.258140563965},
{2812.142578125,-1332.0810546875,32.207908630371},
{2778.802734375,-1365.7109375,24.604793548584},
{2807.5556640625,-1369.9189453125,23.417491912842},
{2853.2119140625,-1366.115234375,14.1640625},
{2842.33984375,-1336.2236328125,14.742118835449},
{2847.8857421875,-1309.1572265625,14.790662765503},
{2809.2177734375,-1189.091796875,25.317050933838},
{2807.9443359375,-1177.3212890625,25.378120422363},
{2820.58203125,-1160.361328125,25.341686248779},
{2793.703125,-1082.28125,30.71875},
{2666.2001953125,-1107.6357421875,69.400970458984},
{2629.4951171875,-1068.3662109375,69.617057800293},
{2612.2919921875,-1081.6611328125,69.597839355469},
{2610.4111328125,-1096.9375,69.514892578125},
{2626.513671875,-1098.6513671875,69.367218017578},
{2621.3955078125,-1119.2119140625,67.545845031738},
{2614.283203125,-1202.2919921875,60},
{2608.5859375,-1207.875,59.0703125},
{2608.1591796875,-1216.6357421875,56.762214660645},
{2614.6767578125,-1239.6708984375,49.786777496338},
{2698.8125,-1202.8974609375,67.981636047363},
{2692.04296875,-1224.041015625,61.467155456543},
{2672.2861328125,-1237.6181640625,55.769592285156},
{2661.802734375,-1216.6318359375,62.057613372803},
{2588.4580078125,-975.6484375,81.391235351562},
{2582.697265625,-953.837890625,81.387008666992},
{2529.14453125,-963.65234375,82.363723754883},
{2499.455078125,-948.7939453125,82.267784118652},
{2472.3134765625,-964.630859375,80.138618469238},
{2454.17578125,-964.7099609375,80.073120117188},
{2579.7705078125,-1033.521484375,69.580101013184},
{2561.263671875,-1034.2744140625,69.575614929199},
{2527.078125,-1060.8125,69.567825317383},
{2513.33984375,-1027.87890625,70.0859375},
{2505.1318359375,-1020.552734375,70.0859375},
{2478.220703125,-1062.4609375,66.8359375},
{2468.0244140625,-1011.853515625,59.7734375},
{2433.9296875,-1012.8134765625,54.34375},
{2389.9501953125,-1037.375,53.564434051514},
{2370.0009765625,-1035.58984375,54.410556793213},
{2335.3798828125,-1045.0556640625,52.358196258545},
{2298.2197265625,-1054.1796875,49.933994293213},
{2256.8583984375,-1069.4482421875,49.4765625},
{2258.994140625,-1029.8837890625,52.679298400879},
{2267.07421875,-1031.421875,59.294151306152},
{2219.318359375,-1046.7607421875,57.662059783936},
{2249.68359375,-1059.6806640625,55.96875},
{2206.556640625,-988.3662109375,63.9296875},
{2188.3203125,-998.0244140625,62.840515136719},
{2185.7216796875,-997.8642578125,66.46875},
{2176.5703125,-982.5595703125,64.46875},
{2142.8916015625,-978.728515625,61.379306793213},
{2121.9423828125,-971.0498046875,58.207431793213},
{2109.0263671875,-1000.4287109375,60.5078125},
{2066.3505859375,-991.0703125,48.799369812012},
{2056.2587890625,-967.2822265625,46.027828216553},
{2040.896484375,-1014.2470703125,39.7421875},
{2571.443359375,-1091.830078125,67.225723266602},
{2519.7060546875,-1114.5751953125,56.207511901855},
{2453.134765625,-1107.65234375,43.388641357422},
{2438.5380859375,-1104.8828125,42.751155853271},
{2374.568359375,-1138.94921875,29.058792114258},
{2396.5009765625,-1133.5830078125,30.71875},
{2510.5693359375,-1129.529296875,41.127861022949},
{2285.7451171875,-1102.5478515625,37.9765625},
{2249.259765625,-1103.6142578125,41.6015625},
{2187.4267578125,-1082.453125,43.842967987061},
{2219.8798828125,-1082.4580078125,41.630508422852},
{2202.345703125,-1056.236328125,47.107879638672},
{2157.119140625,-1070.9384765625,39.950454711914},
{2138.20703125,-1072.9228515625,27.270616531372},
{2116.7734375,-1049.60546875,26.367670059204},
{2054.30859375,-1067.548828125,25.783622741699},
{2039.37109375,-1061.7158203125,25.650810241699},
{1892.412109375,-1068.2373046875,23.9375},
{1916.2900390625,-1072.822265625,24.253681182861},
{1938.0576171875,-1068.0625,24.418003082275},
{1958.0791015625,-1076.9267578125,24.796701431274},
{1958.7119140625,-1116.0625,27.830497741699},
{1945.291015625,-1116.25,27.447629928589},
{1925.37890625,-1114.482421875,27.088310241699},
{1888.9873046875,-1112.984375,26.275810241699},
{1998.02734375,-1114.7236328125,26.773735046387},
{2004.1845703125,-1115.0048828125,27.125},
{2029.408203125,-1121.5654296875,26.416379928589},
{2045.119140625,-1111.8828125,26.361747741699},
{2094.2353515625,-1125.69921875,27.689872741699},
{2090.580078125,-1163.9970703125,26.588254928589},
{2090.44921875,-1233.9052734375,25.477380752563},
{2107.2646484375,-1250.5537109375,25.48588180542},
{2133.24609375,-1232.818359375,24.421875},
{2151.2109375,-1285.6005859375,24.19647026062},
{2094.416015625,-1275.6552734375,25.497339248657},
{2096.490234375,-1277.3701171875,25.49262046814},
{2100.8515625,-1321.87109375,25.953125},
{2122.5712890625,-1321.7568359375,26.626171112061},
{2113.5283203125,-1358.5498046875,23.984375},
{2130.3740234375,-1362.748046875,25.546340942383},
{2146.8779296875,-1366.91015625,25.64178276062},
{2187.9775390625,-1364.3330078125,25.82928276062},
{2206.30078125,-1364.052734375,25.672866821289},
{2253.5390625,-1364.14453125,24.53125},
{2232.71484375,-1280.1455078125,25.3671875},
{2191.7138671875,-1275.6845703125,25.15625},
{2191.189453125,-1238.0439453125,23.9765625},
{2229.7109375,-1241.53125,25.65625},
{2250.3671875,-1238.8798828125,25.8984375},
{2232.4921875,-1177.318359375,29.804386138916},
{2352.0947265625,-1180.208984375,27.975339889526},
{2337.216796875,-1234.009765625,27.9765625},
{2349.7744140625,-1281.587890625,27.9765625},
{2383.3935546875,-1367.8515625,24.491352081299},
{2402.79296875,-1329.9208984375,25.403764724731},
{2388.138671875,-1279.7783203125,25.129104614258},
{2420.884765625,-1220.4638671875,25.485147476196},
{2435.2666015625,-1289.1884765625,25.347854614258},
{2435.7802734375,-1321.3994140625,24.779174804688},
{2467.21484375,-1412.640625,23.75},
{2466.9775390625,-1425.2802734375,23.75},
{2464.0390625,-1317.8935546875,27.390625},
{2480.41015625,-1329.8525390625,28.292972564697},
{2469.0625,-1277.4130859375,30.366352081299},
{2502.1044921875,-1324.89453125,33.429763793945},
{2496.0166015625,-1390.96875,28.839567184448},
{2475.9150390625,-1400.0908203125,28.834657669067},
{2495.916015625,-1431.7099609375,29.016227722168},
{2492.173828125,-1240.556640625,37.361846923828},
{2515.2861328125,-1242.2958984375,39.022338867188},
{2529.9462890625,-1244.068359375,43.65625},
{2550.12890625,-1234.271484375,49.001361846924},
{2557.572265625,-1210.79296875,54.53125},
{2528.0341796875,-1209.48828125,50.28125},
{2537.396484375,-1362.9814453125,30.457332611084},
{2015.623046875,-1289.8779296875,23.984375},
{2002.3154296875,-1309.7451171875,25.222122192383},
{2158.673828125,-1489.306640625,26.654174804688},
{2148.6591796875,-1485.41015625,26.623416900635},
{2149.6455078125,-1432.9677734375,26.018363952637},
{2150.353515625,-1419.4072265625,25.921875},
{2151.1083984375,-1400.7060546875,26.128503799438},
{2188.5517578125,-1417.90234375,26.15625},
{2191.66015625,-1455.3330078125,25.740631103516},
{2190.3427734375,-1488.7939453125,25.77459526062},
{2232.7568359375,-1469.3779296875,24.581628799438},
{2248.591796875,-1469.337890625,24.149597167969},
{-1371.396484375,2053.23046875,52.515625},
{-1426.8818359375,2171.048828125,50.625},
{2245.6708984375,-1396.880859375,24},
{-1503.2607421875,1978.3623046875,48.421875},
{2352.00390625,-1412.2373046875,23.992404937744},
{-1500.2109375,1960.158203125,49.0234375},
{2414.0576171875,-1424.5029296875,23.982444763184},
{2508.5029296875,-1493.6025390625,23.998546600342},
{1797.8603515625,-1578.8251953125,14.090040206909},
{-2471.451171875,1537.7080078125,33.234375},
{-2477.275390625,1550.2998046875,33.234375},
{1787.0849609375,-1638.8837890625,14.469971656799},
{1772.720703125,-1658.798828125,14.42511177063},
{1739.966796875,-1562.626953125,14.162391662598},
{1771.6943359375,-1548.0390625,9.9088573455811},
{1910.2412109375,-1911.9130859375,15.256797790527},
{1937.435546875,-1907.333984375,15.256797790527},
{-1049.486328125,1550.572265625,33.437610626221},
{-782.046875,1557.677734375,27.1171875},
{-797.072265625,1557.283203125,27.124444961548},
{-734.2724609375,1547.3525390625,38.979309082031},
{-732.8095703125,1539.7578125,40.473579406738},
{-731.419921875,1535.5341796875,40.236835479736},
{-771.595703125,1447.5087890625,13.9453125},
{-811.673828125,1420.900390625,13.9453125},
{-810.2216796875,1469.8037109375,19.22875213623},
{-828.146484375,1463.216796875,14.657393455505},
{-792.99609375,1627.375,27.15625},
{-636.259765625,1445.943359375,13.996495246887},
{-692.5068359375,960.24609375,12.220783233643},
{-671.8203125,960.7392578125,12.1328125},
{-671.74609375,970.9345703125,12.1328125},
{-690.490234375,970.71484375,12.201937675476},
{-690.787109375,939.44921875,13.6328125},
{-685.3828125,941.7919921875,13.6328125},
{-683.9716796875,932.15234375,13.6328125},
{2139.546875,-1733.9208984375,17.2890625},
{2155.958984375,-1733.3662109375,17.281345367432},
{-825.3759765625,1823.8203125,7.0000076293945},
{-608.0703125,1831.8974609375,7},
{2147.3056640625,-1819.6796875,16.140625},
{2149.7861328125,-1803.84375,16.153861999512},
{2247.59375,-1795.16015625,13.546875},
{2275.5673828125,-1788.400390625,13.546875},
{-782.9736328125,2147.8447265625,60.3828125},
{2345.359375,-1786.2158203125,13.546875},
{-651.427734375,2153.4443359375,60.3828125},
{2379.650390625,-1784.9951171875,13.546875},
{-793.5537109375,2264.93359375,59.100883483887},
{2466.4453125,-1753.0693359375,13.546875},
{-663.0322265625,2306.0810546875,136.09428405762},
{-662.6083984375,2313.619140625,138.81950378418},
{2500.8662109375,-1759.8662109375,13.546875},
{-774.6181640625,2424.9140625,157.10360717773},
{2538.751953125,-1719.2490234375,13.526076316833},
{-808.076171875,2430.5830078125,156.99356079102},
{2522.9404296875,-1682.7685546875,15.496999740601},
{-911.59375,2672.43359375,42.370262145996},
{-902.7744140625,2695.4619140625,42.370262145996},
{2524.705078125,-1656.3564453125,15.493547439575},
{-853.1787109375,2760.3349609375,46},
{2514.1962890625,-1650.8193359375,14.355666160583},
{-766.888671875,2765.2216796875,48.255599975586},
{-782.57421875,2748.8935546875,45.659553527832},
{-672.880859375,2706.0185546875,70.663284301758},
{2487.62890625,-1697.6142578125,14.765625},
{2491.6435546875,-1693.2373046875,14.765625},
{2531.4970703125,-1665.455078125,15.16725730896},
{2468.0302734375,-1646.470703125,13.780097007751},
{2451.390625,-1641.7041015625,13.735734939575},
{2412.51953125,-1647.005859375,14.011916160583},
{2384.474609375,-1675.0712890625,14.712868690491},
{2361.5029296875,-1644.130859375,13.523147583008},
{-429.1455078125,2240.5068359375,42.983383178711},
{2327.875,-1682.1748046875,14.917343139648},
{2386.7802734375,-1711.8505859375,14.2421875},
{2307.36328125,-1714.5009765625,14.64959526062},
{-325.0166015625,1852.556640625,42.5078125},
{2228.5361328125,-1721.3740234375,13.561138153076},
{2246.7861328125,-1638.5419921875,15.90740776062},
{2282.8603515625,-1642.0654296875,15.627917289734},
{2305.06640625,-1678.7060546875,14.00115776062},
{2383.8291015625,-1547.9697265625,24.156600952148},
{-310.302734375,1303.041015625,53.664344787598},
{2420.89453125,-1508.4912109375,24},
{2459.216796875,-1491.982421875,24},
{2451.615234375,-1492.8115234375,24},
{-323.1240234375,2676.1044921875,63.6796875},
{-227.2724609375,2711.2919921875,62.9765625},
{-155.6328125,2759.0146484375,62.635894775391},
{-160.4794921875,2727.9775390625,62.177940368652},
{-169.2509765625,2707.455078125,62.540195465088},
{-254.1103515625,2604.5302734375,62.858154296875},
{-258.181640625,2781.6416015625,62.6875},
{-36.5,2349.927734375,24.302555084229},
{81.0498046875,2451.48828125,16.484375},
{263.4287109375,2895.767578125,10.531394958496},
{382.361328125,2607.267578125,16.484375},
{2179.9990234375,-1661.2490234375,14.909368515015},
{2127.7861328125,-1687.8515625,15.0859375},
{153.814453125,-1958.794921875,3.7734375},
{2066.8984375,-1657.2578125,14.096161842346},
{2067.7373046875,-1642.2138671875,13.805846214294},
{2068.134765625,-1628.8974609375,13.87615776062},
{2068.2138671875,-1588.6298828125,13.490336418152},
{2079.0244140625,-1554.759765625,13.402491569519},
{2064.576171875,-1558.9169921875,13.439072608948},
{415.11328125,2531.3271484375,19.168476104736},
{428.2197265625,2545.3662109375,16.249221801758},
{424.1630859375,2536.3037109375,16.1484375},
{2017.533203125,-1630.0791015625,13.712096214294},
{2016.3212890625,-1643.41796875,13.78240776062},
{2018.220703125,-1704.8896484375,14.234375},
{2015.3154296875,-1734.177734375,14.234375},
{1977.828125,-1714.75390625,17.037658691406},
{1973.5517578125,-1705.60546875,15.96875},
{1975.056640625,-1678.78125,17.071880340576},
{1973.3056640625,-1654.69140625,15.96875},
{1974.6650390625,-1635.400390625,15.96875},
{1974.9912109375,-1633.9052734375,18.568988800049},
{1965.04296875,-1592.8447265625,13.572462081909},
{394.4560546875,2680.8642578125,59.156536102295},
{1973.955078125,-1561.2412109375,13.637348175049},
{91.025390625,2707.1669921875,53.903339385986},
{537.755859375,2364.4638671875,30.674282073975},
{546.197265625,2277.400390625,34.860118865967},
{-126.1220703125,2255.048828125,28.151527404785},
{202.328125,1873.291015625,13.140625},
{-85,1516.830078125,15.561989784241},
{20.6728515625,1344.7451171875,9.171875},
{7.41015625,1382.4853515625,9.1781387329102},
{-21.0107421875,1389.525390625,9.171875},
{1863.1865234375,-1597.7900390625,14.306245803833},
{1866.560546875,-1598.0615234375,14.26363658905},
{1752.416015625,-1473.1533203125,13.509583473206},
{1739.8955078125,-1460.642578125,13.504856109619},
{4.1708984375,1346.287109375,9.171875},
{1594.4052734375,-1560.1611328125,14.165175437927},
{1576.7822265625,-1470.3623046875,14.23811340332},
{541.8642578125,1556.9052734375,1},
{613.3564453125,1548.4521484375,4.7992935180664},
{708.8984375,1600.005859375,4.0251665115356},
{666.9912109375,1701.642578125,7.1948890686035},
{693.7490234375,1966.4921875,5.5390625},
{700.498046875,1992.796875,5.53125},
{710.4248046875,1983.1796875,3.468513250351},
{709.40625,1208.09765625,13.848057746887},
{710.3564453125,1192.966796875,13.396438598633},
{501.6162109375,1116.044921875,15.035557746887},
{397.8681640625,1159.357421875,8.3480567932129},
{110.7041015625,1105.08203125,13.609375},
{23.259765625,969.015625,19.800422668457},
{-2.3349609375,953.7919921875,19.638710021973},
{-54.3759765625,894.7314453125,22.387119293213},
{-124.6806640625,918.572265625,19.909372329712},
{17.3505859375,910.84375,23.849599838257},
{32.33984375,921.3662109375,23.600179672241},
{69.9091796875,973.13671875,15.86469078064},
{-93.052734375,971.3857421875,19.942081451416},
{-220.8310546875,988.787109375,19.638097763062},
{-180.0888671875,1087.79296875,19.7421875},
{-206.7109375,1087.46875,19.7421875},
{-186.92578125,1210.0517578125,19.687629699707},
{-143.953125,1224.33984375,19.899219512939},
{-66.1025390625,1210.26171875,22.436527252197},
{-28.69921875,1215.2255859375,22.464834213257},
{14.1279296875,1181.6396484375,19.430858612061},
{-19.083984375,1176.1220703125,19.563381195068},
{-93.0234375,1159.0849609375,19.7421875},
{-107.236328125,1138.9287109375,19.7421875},
{-101.1640625,1109.240234375,19.7421875},
{8.625,1069.8984375,20.939865112305},
{-30.1484375,1045.8837890625,20.939867019653},
{-251.4169921875,1050.0458984375,20.939863204956},
{-304.2783203125,1120.6806640625,19.7421875},
{-328.810546875,1119.837890625,20.939863204956},
{-362.8330078125,1110.7998046875,20.939865112305},
{-360.1904296875,1139.310546875,20.939867019653},
{-369.44140625,1168.9306640625,20.27187538147},
{-362.171875,1191.5791015625,19.7421875},
{-220.6748046875,1173.96875,19.7421875},
{-207.5810546875,1118.9912109375,20.4296875},
{-319.3681640625,818.01171875,14.421697616577},
{-453.0341796875,616.1943359375,16.815383911133},
{322.958984375,854.0498046875,20.40625},
{585.5908203125,875.73046875,-42.497318267822},
{713.50390625,908.9951171875,-18.846324920654},
{771.978515625,1883.607421875,4.9840874671936},
{754.4326171875,1972.8193359375,5.69961977005},
{792.923828125,1991.4208984375,5.79336977005},
{765.0244140625,2006.4072265625,6.06680727005},
{2680.8095703125,868.7412109375,10.939546585083},
{2678.880859375,826.673828125,10.954463005066},
{2660.4013671875,748.0615234375,14.739588737488},
{2654.783203125,717.2900390625,14.739588737488},
{2576.2353515625,714.0361328125,14.739588737488},
{2534.853515625,747.3837890625,10.8203125},
{2463.8046875,735.083984375,11.4609375},
{2465.0029296875,658.095703125,11.359375},
{2398.5517578125,672.3798828125,11.359375},
{2370.3544921875,676.943359375,11.460479736328},
{2328.849609375,663.1591796875,11.453125},
{2308.1220703125,676.271484375,11.3836145401},
{2350.1416015625,734.55078125,11.468292236328},
{2369.521484375,749.2099609375,11.4609375},
{2386.4169921875,741.9736328125,11.359375},
{2260.9580078125,733.603515625,11.4609375},
{2226.6640625,748.1552734375,11.4609375},
{2200.6630859375,751.095703125,11.183270454407},
{2178.9306640625,758.9052734375,11.4609375},
{2181.12109375,695.744140625,11.27140045166},
{2227.818359375,654.0703125,11.4609375},
{2320.6142578125,654.0341796875,11.453125},
{2247.3857421875,584.5341796875,7.78125},
{2179.01953125,654.4892578125,11.4609375},
{2131.1708984375,650.080078125,11.4609375},
{2106.2626953125,698.9853515625,11.366704940796},
{2086.5830078125,715.8388671875,11.789765357971},
{2047.3916015625,772.5830078125,11.453125},
{2128.9189453125,789.8076171875,11.34375},
{2010.998046875,707.5966796875,11.4609375},
{2013.3037109375,652.1025390625,11.4609375},
{2043.3115234375,638.1796875,11.4609375},
{1955.9228515625,737.7890625,14.281055450439},
{1898.140625,736.6279296875,14.2734375},
{1899.2177734375,679.806640625,14.2734375},
{1924.142578125,665.4296875,10.8203125},
{1936.244140625,663.978515625,10.8203125},
{1951.5908203125,671.6162109375,10.8203125},
{1846.5576171875,691.26171875,11.453125},
{1844.888671875,654.7294921875,11.4609375},
{1453.822265625,749.66796875,11.0234375},
{1532.0380859375,752.9267578125,11.0234375},
{1544.1845703125,676.5625,11.328125},
{1093.51953125,996.80078125,11},
{1020.4912109375,1056.2265625,11},
{1163.0771484375,1342.119140625,10.812517166138},
{1165.5888671875,1348.1884765625,10.921875},
{1174.2158203125,1349.439453125,10.921875},
{1123.162109375,1463.23046875,5.8203125},
{1090.80078125,1456.6982421875,5.8203125},
{1070.638671875,1594.9052734375,5.8203125},
{1105.337890625,1601.8115234375,5.8203125},
{1110.5263671875,1598.626953125,12.546875},
{1087.4208984375,1597.8759765625,12.546875},
{963.994140625,1792.7421875,8.8515625},
{1034.919921875,1840.5966796875,11.468292236328},
{971.103515625,1887.0078125,11.468292236328},
{937.068359375,1920.517578125,11.468292236328},
{971.0712890625,1977.146484375,11.468292236328},
{1027.81640625,1926.576171875,11.468292236328},
{1021.2802734375,1972.55078125,11.163819313049},
{1025.3779296875,2026.5234375,11.347480773926},
{957.7919921875,2256.5654296875,11.3671875},
{986.890625,2272.4775390625,11.4609375},
{987.044921875,2312.845703125,11.4609375},
{970.8828125,2350.4130859375,11.46875},
{1225.7939453125,2616.9736328125,10.8203125},
{1265.474609375,2608.0849609375,10.8203125},
{1276.072265625,2522.248046875,10.8203125},
{1328.9736328125,2521.4775390625,10.826429367065},
{1325.2548828125,2568.6103515625,10.8203125},
{1344.6630859375,2608.3330078125,10.8203125},
{1412.0693359375,2577.4931640625,10.826509475708},
{1451.1142578125,2567.16796875,10.8203125},
{1503.6923828125,2570.044921875,10.8203125},
{1515.609375,2607.4580078125,10.8203125},
{1551.619140625,2567.365234375,10.8203125},
{1596.6640625,2568.2353515625,10.8203125},
{1623.4375,2570.0888671875,10.8203125},
{1556.6337890625,2661.298828125,10.8203125},
{1573.2255859375,2661.7197265625,10.8203125},
{1457.4462890625,2771.947265625,10.8203125},
{1448.9794921875,2774.0263671875,18.8203125},
{1442.6376953125,2796.767578125,19.5234375},
{1426.5166015625,2780.7314453125,14.8203125},
{1426.21875,2799.0908203125,14.8203125},
{1388.9599609375,2656.1787109375,11.392612457275},
{1478.05859375,2651.5498046875,11.392612457275},
{1437.7451171875,2646.77734375,11.392612457275},
{1431.771484375,2622.7216796875,11.392614364624},
{1570.548828125,2715.2548828125,10.8203125},
{1576.6708984375,2751.9453125,11.343775749207},
{1561.107421875,2794.79296875,10.8203125},
{1575.3896484375,2840.87890625,10.8203125},
{1601.5283203125,2805.9091796875,10.8203125},
{1638.8935546875,2834.953125,10.8203125},
{1655.4033203125,2805.14453125,10.8203125},
{1675.59765625,2800.6513671875,10.8203125},
{1671.92578125,2744.462890625,10.8203125},
{1634.5390625,2745.3359375,10.8203125},
{1609.2421875,2718.5244140625,10.8203125},
{1626.7646484375,2714.0478515625,10.8203125},
{1676.8466796875,2695.7880859375,10.8203125},
{1703.9306640625,2693.53125,10.8203125},
{1736.3994140625,2694.12109375,10.8203125},
{1741.6904296875,2859.5185546875,11.3359375},
{1761.609375,2866.7099609375,11.3359375},
{1772.1669921875,2867.37890625,11.3359375},
{1794.0322265625,2858.716796875,14.257873535156},
{1772.7841796875,2866.625,14.265625},
{1734.9638671875,2827.7783203125,11.350912094116},
{1736.9287109375,2815.4765625,11.34375},
{1747.41015625,2769.404296875,11.34375},
{1752.3359375,2760.3232421875,11.350912094116},
{1776.591796875,2747.908203125,11.34375},
{1782.15625,2767.41796875,11.350912094116},
{1792.1376953125,2802.7001953125,11.34375},
{1795.0126953125,2813.4033203125,11.34375},
{1802.619140625,2835.9482421875,14.273517608643},
{1795.212890625,2815.33984375,14.273517608643},
{1756.2978515625,2746.171875,14.273517608643},
{1751.9404296875,2757.822265625,14.273517608643},
{1747.5029296875,2770.5400390625,14.273517608643},
{1836.4345703125,2838.580078125,10.8359375},
{1835.65625,2827.3056640625,10.8359375},
{1852.9501953125,2857.572265625,11.902812957764},
{1884.30859375,2877.162109375,10.8359375},
{1887.5224609375,2802.2216796875,11.34375},
{1878.9052734375,2793.6416015625,11.34375},
{1863.0244140625,2777.3564453125,14.265686035156},
{1879.77734375,2793.5341796875,14.2734375},
{1855.607421875,2766.4091796875,14.265686035156},
{1837.75,2751.4873046875,14.2734375},
{1825.97265625,2648.955078125,10.8203125},
{1844.521484375,2648.0107421875,10.8203125},
{1863.384765625,2648.13671875,10.8203125},
{1880.474609375,2646.9970703125,10.8203125},
{1869.1171875,2584.466796875,10.8203125},
{1887.80078125,2585.03515625,10.8203125},
{1925.587890625,2606.3720703125,10.8203125},
{1944.2724609375,2605.9501953125,10.8203125},
{1949.5625,2661.6376953125,10.8203125},
{1947.16796875,2707.3603515625,10.8203125},
{2010.0546875,2707.474609375,11.20196056366},
{2011.0693359375,2728.6357421875,10.827390670776},
{2017.3642578125,2754.951171875,10.8203125},
{1961.4599609375,2756.41796875,10.8203125},
{1919.3740234375,2768.7958984375,10.826509475708},
{2009.8427734375,2680.1689453125,10.8203125},
{2143.6982421875,2835.0341796875,10.8203125},
{2618.861328125,2724.796875,36.538642883301},
{2823.466796875,2268.119140625,14.661463737488},
{2817.1748046875,2275.263671875,14.661463737488},
{2793.5400390625,2222.580078125,10.8203125},
{2794.3525390625,2228.98046875,14.661463737488},
{2824.0146484375,2206.849609375,10.812986373901},
{2819.1474609375,2140.6875,14.661464691162},
{2826.0498046875,2125.791015625,10.8203125},
{2809.8876953125,2067.072265625,10.735213279724},
{2809.7685546875,2049.3828125,10.790351867676},
{2834.6787109375,2049.7626953125,10.8203125},
{2836.0009765625,2083.8603515625,10.8203125},
{-2229.0498046875,252.37890625,35.3203125},
{-2547.072265625,392.6298828125,22.015625},
{-2513.5068359375,849.2216796875,52.6953125},
{-2513.9052734375,885.67578125,62.764999389648},
{-2502.8212890625,921.3798828125,65.241363525391},
{-2449.8701171875,921.41796875,58.144382476807},
{-2374.1484375,931.5830078125,45.414939880371},
{-2113.2744140625,978.0263671875,71.515625},
{-2041.939453125,979.51171875,54.677085876465},
{-1625.783203125,944.388671875,10.6484375},
{-1582.0908203125,955.869140625,7.1875},
{-1594.775390625,975.8095703125,7.1875},
{-1614.9228515625,1002.02734375,7.1875},
{-1616.353515625,1097.9267578125,7.1875},
{-1617.5341796875,1155.9814453125,7.1875},
{-1492.1396484375,920.0009765625,7.1875},
{-1606.1083984375,773.2783203125,7.1875},
{-1422.5283203125,-285.8115234375,14.1484375},
{-1388.7177734375,-328.6025390625,14.280866622925},
{-2051.763671875,-480.5322265625,38.734375},
{-1971.513671875,-1019.2958984375,32.171875},
{-2002.3720703125,-1020.7861328125,32.171875},
{-2209.978515625,-2288.8974609375,30.625},
{-2223.248046875,-2293.5615234375,31.671875},
{-2188.8271484375,-2344.521484375,30.625},
{-2157.787109375,-2337.0458984375,30.625},
{-2103.9794921875,-2341.955078125,30.625},
{-2129.5556640625,-2375.3505859375,30.625},
{-2144.109375,-2425.78515625,30.625},
{-2105.984375,-2480.7490234375,30.625},
{-2057.5341796875,-2464.5439453125,31.1796875},
{-2079.3056640625,-2448.56640625,30.625},
{-2093.65625,-2464.8388671875,30.625},
{-2132.513671875,-2511.123046875,31.816272735596},
{-2161.455078125,-2535.5439453125,31.816270828247},
{-2199.8115234375,-2512.4248046875,31.816270828247},
{-2189.3662109375,-2533.4150390625,31.1171875},
{-2227.697265625,-2489.3681640625,31.816272735596},
{-2214.03125,-2451.876953125,31.816270828247},
{-2239.0341796875,-2423.8388671875,32.70726776123},
{-2161.333984375,-2384.7919921875,30.895784378052},
{-2087.3359375,-2510.623046875,31.066806793213},
{-2058.1669921875,-2503.5595703125,31.066806793213},
{-2075.21484375,-2526.1865234375,31.066806793213},
{-2068.947265625,-2561.501953125,31.066806793213},
{-2031.2890625,-2538.904296875,31.066806793213},
{-1855.173828125,-1560.04296875,22.453125},
{-2242.337890625,191.2001953125,35.3203125},
{1722.68359375,-2334.0068359375,13.546875},
{-2197.4892578125,1190.759765625,55.69548034668},
{1632.326171875,-2335.2197265625,13.539954185486},
{-2351.1376953125,1299.45703125,19.584844589233},
{1682.185546875,-2240.4375,-2.6991682052612},
{1640.166015625,-2333.09765625,-2.6796875},
{-2312.478515625,848.5205078125,71.382347106934},
{-2231.46875,-2558.251953125,31.921875},
{-2663.8955078125,552.2001953125,14.609375},
{-2890.9560546875,738.5390625,29.171875},
{-2477.83984375,1338.0986328125,8.5038833618164},
{-890.25,20.0693359375,31.13649559021},
{-877.8994140625,25.2763671875,30.586343765259},
{-100.333984375,-104.8505859375,3.1180820465088},
{148.2802734375,-159.6787109375,1.578125},
{178.220703125,-120.2314453125,1.5490583181381},
{160.6337890625,-102.615234375,4.8964710235596},
{207.0751953125,-102.7646484375,4.8964710235596},
{209.0244140625,-112.3701171875,1.5508496761322},
{252.8828125,-121.212890625,3.5353934764862},
{267.8115234375,-54.5546875,2.7772099971771},
{295.1337890625,-54.587890625,2.7772107124329},
{196.82421875,-119.9599609375,1.5502977371216},
{175.7138671875,-95.23828125,1.5502822399139},
{158.568359375,-106.9755859375,4.8964710235596},
{312.7353515625,-92.474609375,3.5353934764862},
{312.7373046875,-121.0869140625,3.5353941917419},
{259.4619140625,-302.591796875,1.9183698892593},
{254.9072265625,-191.6904296875,1.578125},
{301.017578125,-188.7138671875,1.578125},
{262.0185546875,-270.0517578125,1.6404900550842},
{263.06640625,21.927734375,3.4331963062286},
{252.3095703125,-91.1962890625,3.5353941917419},
{202.7607421875,-202.33984375,1.578125},
{214.5166015625,-183.0888671875,1.578125},
{1224.6318359375,249.9892578125,19.546894073486},
{1256.712890625,274.861328125,19.5546875},
{1294.9140625,235.7802734375,19.5546875},
{1244.341796875,205.4287109375,19.645431518555},
{1317.69140625,224.4599609375,19.56298828125},
{1386.556640625,293.2529296875,19.54688835144},
{1273.4189453125,238.228515625,19.610862731934},
{1356.849609375,308.119140625,19.747299194336},
{1310.93359375,330.0146484375,19.9140625},
{1323.8916015625,375.58203125,19.562463760376},
{1276.9384765625,370.6611328125,19.5546875},
{1297.0400390625,353.3994140625,19.5546875},
{1292.4677734375,311.6064453125,19.5546875},
{1264.4326171875,285.201171875,19.5546875},
{1272.0859375,309.3125,19.5546875},
{1235.0078125,360.2578125,19.5546875},
{1253.2470703125,352.0009765625,19.5546875},
{1295.0400390625,175.3095703125,20.910556793213},
{1312.7119140625,170.0556640625,20.4609375},
{1340.1689453125,216.1025390625,19.5546875},
{1363.908203125,192.3173828125,24.227144241333},
{2203.8583984375,62.23046875,28.441644668579},
{2161.8505859375,-104.626953125,2.7078378200531},
{2160.43359375,-101.869140625,2.75},
{2186.98828125,-89.583984375,28.153547286987},
{2198.1689453125,-57.9453125,28.153549194336},
{2202.744140625,-38.5810546875,28.153547286987},
{2250.765625,-2.5986328125,28.153551101685},
{2247.2744140625,-121.373046875,28.153547286987},
{2267.1982421875,-139.845703125,27.4765625},
{2293.5185546875,-134.3857421875,28.153959274292},
{2321.2763671875,-124.15625,28.153551101685},
{2256.138671875,-44.03125,26.683433532715},
{2266.3125,-76.5771484375,24.5859375},
{2368.3134765625,-64.7060546875,28.153547286987},
{2387.15234375,-53.431640625,28.153551101685},
{2436.2548828125,-54.2744140625,28.153549194336},
{2439.45703125,-71.5087890625,28.153959274292},
{2203.8623046875,106.1181640625,28.44164276123},
{2249.404296875,111.759765625,28.44164276123},
{2251.763671875,80.04296875,26.703674316406},
{2445.021484375,-13.126953125,27.683458328247},
{2269.6240234375,111.7685546875,28.441644668579},
{2432.73046875,-0.875,26.484375},
{2273.1865234375,82.1259765625,26.484375},
{2285.7744140625,161.7666015625,28.44164276123},
{2410.328125,-7.28515625,27.683460235596},
{2258.0439453125,168.3134765625,28.153551101685},
{2416.19921875,17.8681640625,27.683458328247},
{2236.404296875,168.302734375,28.153549194336},
{2374.3173828125,22.654296875,28.44164276123},
{2323.8896484375,116.1103515625,28.44164276123},
{2373.865234375,49.236328125,28.441644668579},
{2363.9697265625,116.05859375,28.441644668579},
{2323.8759765625,136.4765625,28.44164276123},
{2366.390625,40.341796875,28.44164276123},
{2363.9970703125,141.7978515625,28.44164276123},
{2323.8486328125,162.4755859375,28.441644668579},
{2363.986328125,165.8994140625,28.441644668579},
{2323.875,191.03515625,28.44164276123},
{2363.9931640625,187.1484375,28.44164276123},
{2307.013671875,-4.8701171875,26.7421875},
{2310.9267578125,-9.912109375,26.7421875},
{2333.611328125,51.7109375,26.627893447876},
{2324.1884765625,-3.5205078125,26.557140350342},
{2332.97265625,-4.00390625,26.560916900635},
{2327.888671875,8.4453125,26.531627655029},
{2484.3359375,-28.353515625,28.44164276123},
{2488.328125,11.7509765625,28.44164276123},
{2513.419921875,-28.375,28.441644668579},
{2558.2197265625,-11.2705078125,27.675647735596},
{2549.19921875,25.4013671875,27.675647735596},
{2398.416015625,110.73046875,28.44164276123},
{2551.20703125,57.1240234375,27.675645828247},
{2444.046875,97.8427734375,28.441644668579},
{2556.9736328125,87.7666015625,27.675645828247},
{2494.595703125,88.2958984375,26.484375},
{2561.78125,72.1796875,26.4765625},
{2537.916015625,128.3974609375,27.683460235596},
{2513.9208984375,94.4111328125,27.683460235596},
{2504.732421875,134.0849609375,26.4765625},
{2462.7822265625,134.2802734375,27.675645828247},
{2481.0791015625,125.8642578125,27.675647735596},
{2456.7744140625,127.2626953125,27.675647735596},
{2412.8662109375,70.7548828125,28.44164276123},
{1547.08984375,32.642578125,24.140625},
{1105.8349609375,-301.82421875,74.5390625},
{1106.46875,-316.521484375,74.7421875},
{614.388671875,-518.3642578125,16.353294372559},
{624.8662109375,-506.2568359375,16.352542877197},
{654.810546875,-503.103515625,16.3359375},
{695.048828125,-500.1318359375,16.3359375},
{818.771484375,-495.69140625,18.012922286987},
{742.337890625,-495.80078125,18.012922286987},
{795.482421875,-497.193359375,18.013332366943},
{768.375,-503.7763671875,18.012926101685},
{766.5439453125,-556.5673828125,18.012924194336},
{745.232421875,-556.7734375,18.012926101685},
{800.810546875,-574.1591796875,16.3359375},
{691.248046875,-621.69140625,16.3359375},
{820.1103515625,-575.345703125,16.536296844482},
{673.2314453125,-634.4541015625,16.3359375},
{857.2412109375,-602.9853515625,18.421875},
{691.84765625,-546.6572265625,16.3359375},
{849.98828125,-604.048828125,18.421875},
{745.349609375,-591.0302734375,18.012922286987},
{716.541015625,-468.16796875,16.343704223633},
{673.0771484375,-460.72265625,16.536296844482},
{609.509765625,-611.48828125,17.2265625},
{609.5478515625,-595.8916015625,17.233013153076},
{606.294921875,-581.365234375,16.636558532715},
{2095.3544921875,-1145.32421875,26.592920303345},
{1852.3740234375,-1144.9921875,23.834211349487},
{1852.3232421875,-1092.921875,23.828125},
{1831.0498046875,-1092.1767578125,23.838096618652},
{1833.751953125,-1125.6044921875,24.672080993652},
{1796.8720703125,-1149.1142578125,23.749704360962},
{1700.3095703125,-1171.275390625,23.843555450439},
{1730.1767578125,-1181.998046875,23.838611602783},
{1792.90625,-1163.4306640625,23.828125},
{1830.556640625,-1172.0546875,24.265625},
{1808.1728515625,-1436.2373046875,13.4296875},
{1764.3583984375,-1398.005859375,15.7578125},
{1789.0791015625,-1383.9853515625,15.7578125},
{1765.7978515625,-1341.994140625,15.758672714233},
{1684.4501953125,-1345.8330078125,17.433988571167},
{1734.76953125,-1265.439453125,13.542039871216},
{1691.03515625,-1200.0849609375,19.8984375},
{1650.560546875,-1199.1298828125,19.781862258911},
{1569.3662109375,-1198.900390625,19.7890625},
{1528.875,-1151.2177734375,24.078125},
{1566.1611328125,-1171.3837890625,24.095048904419},
{1631.830078125,-1172.927734375,24.084280014038},
{1673.3291015625,-1171.041015625,23.972120285034},
{1658.5478515625,-1342.62890625,17.438894271851},
{1570.64453125,-1337.533203125,16.484375},
{1500.3759765625,-1337.107421875,14.021427154541},
{1516.646484375,-1399.5546875,14.011289596558},
{1667.8896484375,-1533.5478515625,13.546875},
{1648.3720703125,-1469.2060546875,13.546875},
{1689.66015625,-1518.0146484375,13.546875},
{1670.46875,-1581.7578125,13.546875},
{1555.7529296875,-1634.4580078125,6.21875},
{1568.6025390625,-1689.9833984375,6.21875},
{1419.185546875,-1607.17578125,13.546875},
{1419.1826171875,-1640.2978515625,13.546875},
{1410.2939453125,-1701.4365234375,13.539485931396},
{1341.330078125,-1675.177734375,17.71573638916},
{1341.3544921875,-1648.96875,17.719120025635},
{1327.890625,-1556.087890625,13.546875},
{1347.8154296875,-1501.3310546875,13.546875},
{1333.091796875,-1522.33984375,13.546875},
{1360.2177734375,-1469.576171875,13.546875},
{1368.3525390625,-1432.541015625,14.0546875},
{1387.353515625,-1438.6533203125,13.5546875},
{1408.470703125,-1385.607421875,13.572636604309},
{1370.8134765625,-1365.4697265625,13.546875},
{1370.6337890625,-1320.107421875,13.546875},
{1424.6103515625,-1086.5908203125,17.550863265991},
{1440.609375,-1095.6064453125,17.62438583374},
{1386.91015625,-1168.6650390625,23.8203125},
{1465.8994140625,-1010.4609375,26.84375},
{1448.890625,-1010.728515625,26.84375},
{1330.3232421875,-985.314453125,33.896629333496},
{1300.2353515625,-992.048828125,35.280891418457},
{1290.7939453125,-1075.2197265625,29.27294921875},
{1285.21484375,-1066.130859375,31.678918838501},
{1284.6728515625,-1089.58203125,28.2578125},
{1320.392578125,-1076.6240234375,29.1796875},
{1291.37890625,-1131.5009765625,23.828125},
{1243.310546875,-1076.3720703125,31.5546875},
{1296.7802734375,-991.564453125,32.6953125},
{1234.81640625,-1437.94921875,13.615178108215},
{1232.875,-1459.0751953125,13.546875},
{1284.8671875,-1464.080078125,10.046875},
{1247.3681640625,-1528.0390625,13.561420440674},
{1148.23828125,-1344.2822265625,13.655700683594},
{1180.0244140625,-1260.689453125,18.8984375},
{1187.322265625,-1254.587890625,18.890762329102},
{1180.595703125,-1255.048828125,15.1796875},
{1186.6298828125,-1226.7841796875,18.5546875},
{1180.81640625,-1227.34765625,22.132949829102},
{1180.0126953125,-1233.4072265625,22.140625},
{1170.3720703125,-1490.9453125,22.755535125732},
{1062.6298828125,-1499.9287109375,22.752643585205},
{1112.4912109375,-1520.8896484375,15.796875},
{1153.83984375,-1181.85546875,32.818702697754},
{1161.640625,-1162.3193359375,32.027549743652},
{1102.423828125,-1092.8701171875,28.46875},
{1142.8388671875,-1069.4052734375,31.765625},
{1102.75,-1069.3359375,31.8828125},
{1069.2041015625,-1080.9345703125,27.532295227051},
{1246.2529296875,-908.962890625,46.6015625},
{1252.869140625,-902.53515625,46.593887329102},
{1248.9677734375,-877.4228515625,42.8828125},
{1242.1826171875,-872.0380859375,46.632949829102},
{1287.1630859375,-867.5517578125,46.836074829102},
{1281.7578125,-874.931640625,46.84375},
{1290.984375,-896.9892578125,42.8828125},
{1439.6669921875,-926.4306640625,39.647666931152},
{1411.228515625,-920.8828125,38.421875},
{1467.9072265625,-917.0048828125,54.839092254639},
{1469.384765625,-904.7822265625,54.8359375},
{1420.697265625,-885.1396484375,50.645557403564},
{1527.41796875,-892.8388671875,57.657482147217},
{1539.822265625,-851.0029296875,64.336059570312},
{1563.318359375,-855.5576171875,61.365352630615},
{1534.9189453125,-800.1513671875,72.849456787109},
{1549.11328125,-803.66015625,72.217529296875},
{1535.44140625,-762.0888671875,79.9453125},
{1497.2705078125,-666.6865234375,95.601257324219},
{1442.8671875,-630.9267578125,95.718566894531},
{1333.8984375,-630.0361328125,109.1349029541},
{1258.3154296875,-785.7998046875,92.030181884766},
{1302.1123046875,-786.5693359375,88.3125},
{1134.892578125,-748.40234375,97.162223815918},
{1111.27734375,-742.2744140625,100.13292694092},
{1095.0439453125,-646.50390625,113.6484375},
{1094.6015625,-661.0712890625,113.6484375},
{1045.3935546875,-641.359375,120.1171875},
{980.0400390625,-677.3671875,121.97625732422},
{992.154296875,-695.625,121.77093505859},
{897.7158203125,-677.494140625,116.89044189453},
{945.8369140625,-710.2158203125,122.61987304688},
{868.3251953125,-715.86328125,105.6796875},
{848.931640625,-745.384765625,94.969268798828},
{808.51953125,-759.94140625,76.531364440918},
{784.984375,-761.169921875,73.560661315918},
{909.6806640625,-816.8798828125,103.12602996826},
{977.6484375,-771.376953125,112.20262908936},
{1017.0146484375,-763.0830078125,112.56301879883},
{1034.3251953125,-811.2109375,101.8515625},
{990.0791015625,-828.50390625,95.468574523926},
{1093.455078125,-805.79296875,107.42092895508},
{937.982421875,-848.236328125,93.632316589355},
{828.65625,-858.4248046875,70.330810546875},
{786.333984375,-827.677734375,70.289581298828},
{835.875,-893.609375,68.768898010254},
{725.0361328125,-997.859375,52.734375},
{730.9892578125,-1013.015625,52.737854003906},
{672.921875,-1020.2392578125,55.759605407715},
{699.2705078125,-1058.7177734375,49.421691894531},
{645.47265625,-1117.919921875,44.207038879395},
{565.7802734375,-1098.4677734375,69.951286315918},
{497.560546875,-1094.9091796875,82.359191894531},
{416.6953125,-1154.544921875,76.687614440918},
{471.3603515625,-1164.3671875,67.170478820801},
{534.728515625,-1173.6796875,58.809711456299},
{580.3369140625,-1149.345703125,53.180084228516},
{358.3115234375,-1207.4990234375,76.518783569336},
{316.11328125,-1139.5576171875,81.593444824219},
{299.66796875,-1154.400390625,81.224769592285},
{350.3330078125,-1197.0029296875,76.515625},
{250.9892578125,-1220.583984375,76.10237121582},
{252.931640625,-1270.10546875,74.399215698242},
{272.65234375,-1281.828125,74.632507324219},
{256.2763671875,-1297.99609375,74.632507324219},
{220.125,-1250.248046875,78.330360412598},
{167.1376953125,-1297.1552734375,70.351257324219},
{168.4248046875,-1321.5234375,70.351257324219},
{255.20703125,-1365.712890625,53.109375},
{298.3076171875,-1338.287109375,53.441452026367},
{228.75,-1403.7080078125,51.60758972168},
{335.8173828125,-1303.744140625,50.759044647217},
{398.68359375,-1271.0029296875,50.019790649414},
{432.056640625,-1253.8876953125,51.580940246582},
{549.4267578125,-1215.0986328125,44.86026763916},
{552.109375,-1200.5830078125,44.831535339355},
{598.68359375,-1194.3447265625,41.784606933594},
{608.8759765625,-1187.1806640625,41.784606933594},
{152.6962890625,-1449.6953125,32.844982147217},
{140.6455078125,-1479.787109375,25.2109375},
{1674.4541015625,1447.390625,10.790289878845},
{1682.275390625,1755.2529296875,10.827277183533},
{1653.578125,1732.27734375,10.8203125},
{1643.8818359375,1912.6865234375,10.8203125},
{1663.1279296875,1912.267578125,10.8203125},
{1671.646484375,1967.9560546875,10.8203125},
{1648.52734375,1977.759765625,10.8203125},
{1611.9306640625,1978.109375,10.8203125},
{1530.740234375,1936.2431640625,10.8203125},
{1511.0576171875,1911.4580078125,10.8203125},
{1735.013671875,2111.724609375,12.2890625},
{1686.2880859375,2046.1767578125,11.46875},
{1673.447265625,2090.677734375,11.4609375},
{1672.0517578125,2130.0087890625,11.4609375},
{1645.0537109375,2128.7568359375,11.203125},
{1639.6298828125,2149.41015625,11.3125},
{1638.119140625,2103.275390625,11.3125},
{1644.87109375,2080.9677734375,11.3125},
{1618.1064453125,2076.033203125,30.529462814331},
{1596.4287109375,2038.126953125,11.46875},
{1597.4423828125,2092.88671875,11.3125},
{1584.388671875,2147.537109375,11.4609375},
{1536.3486328125,2032.8720703125,14.739588737488},
{1542.66796875,2003.1279296875,10.8203125},
{1501.3984375,2027.3271484375,14.739588737488},
{1481.15234375,1998.68359375,10.8203125},
{1473.8974609375,2002.4560546875,10.8203125},
{1456.1259765625,2030.458984375,14.739588737488},
{1416.98828125,2036.68359375,10.8203125},
{1417.9794921875,1999.42578125,10.8203125},
{1422.6806640625,1915.28515625,11.46875},
{1453.978515625,1944.6875,11.468292236328},
{1445.365234375,1949.2958984375,11.4609375},
{1365.646484375,1932.775390625,11.468292236328},
{1335.9306640625,1919.6494140625,11.4609375},
{1319.794921875,1975.5244140625,11.46875},
{1352.830078125,2027.876953125,11.4609375},
{1370.0166015625,1989.18359375,11.308856964111},
{1547.447265625,2125.7880859375,11.4609375},
{1477.5693359375,2194.6318359375,11.0234375},
{1407.4580078125,2221.41796875,11.0234375},
{1369.73828125,2195.5634765625,9.7578125},
{1393.2724609375,2171.2744140625,9.7578125},
{1409.5810546875,2141.7421875,12.015625},
{1413.6455078125,2105.537109375,12.015625},
{1360.4912109375,2213.3759765625,12.015625},
{1442.3857421875,2361.904296875,10.8203125},
{1656.9853515625,2251.1826171875,11.07010269165},
{1838.0458984375,2157.4013671875,10.8203125},
{1855.751953125,2157.0712890625,10.8203125},
{1837.61328125,2093.943359375,10.8203125},
{1892.7275390625,2235.4423828125,11.125},
{1879.2236328125,2235.25,11.125},
{1857.625,2351.8291015625,10.979915618896},
{1856.248046875,2383.25,10.979915618896},
{2023.5849609375,1900.0634765625,12.267676353455},
{2018.970703125,1917.529296875,12.341463088989},
{1968.7294921875,1623.48828125,12.860266685486},
{2001.49609375,1541.267578125,13.5859375},
{1999.31640625,1530.21875,14.622252464294},
{1890.0166015625,1596.4658203125,10.538269996643},
{1868.1669921875,1308.9814453125,16.922344207764},
{1931.69921875,1336.7529296875,9.96875},
{1947.2333984375,1397.4990234375,9.2578125},
{1910.7255859375,1401.818359375,9.2578125},
{1953.0556640625,1343.958984375,15.3671875},
{1993.6875,1241.4521484375,10.8203125},
{2008.46875,1169.8330078125,10.8203125},
{1966.9130859375,1102.0322265625,10.8203125},
{1952.001953125,1101.9404296875,10.8203125},
{1896.0146484375,1142.3056640625,10.8203125},
{1862.666015625,1190.12109375,10.836782455444},
{1859.01171875,1112.12890625,10.8203125},
{1858.84765625,1079.8623046875,10.8203125},
{1859.0625,1050.431640625,10.8203125},
{1858.92578125,994.1474609375,10.8203125},
{1859.4013671875,937.771484375,10.8203125},
{1877.474609375,925.0947265625,10.8203125},
{1927.7822265625,924.265625,10.831217765808},
{1916.3369140625,970.4931640625,10.8203125},
{1909.0107421875,1017.82421875,10.8203125},
{1920.2158203125,964.525390625,10.8203125},
{1960.115234375,953.115234375,10.8203125},
{1999.6953125,991.48046875,10.8203125},
{2021.9443359375,1003.3857421875,10.8203125},
{2021.2001953125,1009.5908203125,10.8203125},
{1946.427734375,2050.9853515625,10.8203125},
{1968.236328125,2294.9638671875,16.455863952637},
{1998.7578125,2302.7958984375,10.8203125},
{2004.5810546875,2309.9541015625,10.8203125},
{2127.40625,2377.3232421875,10.8203125},
{2189.416015625,2399.2802734375,10.8203125},
{2189.416015625,2399.2802734375,10.8203125},
{2166.443359375,2478.806640625,10.8203125},
{2159.64453125,2465.7568359375,10.8203125},
{2114.9013671875,2498.763671875,14.83895111084},
{2099.5068359375,2492.00390625,11.078125},
{2057.7861328125,2483.947265625,11.078125},
{2176.8447265625,2419.779296875,73.03385925293},
{2119.2587890625,884.3779296875,11.186832427979},
{2159.072265625,956.1904296875,11.1015625},
{2249.9599609375,960.7021484375,10.812986373901},
{2491.2060546875,918.8837890625,11.0234375},
{2502.2255859375,926.1259765625,11.0234375},
{2196.83203125,1062.1728515625,10.8203125},
{2182.6611328125,1114.8740234375,12.6484375},
{2413.5078125,1122.8271484375,10.8203125},
{2478.779296875,1063.951171875,10.812517166138},
{2499.1787109375,1149.474609375,22.023197174072},
{2625.6640625,1191.623046875,10.794861793518},
{2633.263671875,1192.841796875,26.918153762817},
{2581.3623046875,1062.3056640625,11.157404899597},
{2546.0205078125,1106.1640625,10.8203125},
{2540.919921875,1232.1962890625,10.958621025085},
{2477.7119140625,1276.30859375,10.8125},
{2448.529296875,1300.859375,10.8203125},
{2178.7080078125,1292.08203125,10.8203125},
{2178.1796875,1285.7978515625,10.8203125},
{2237.60546875,1284.345703125,10.8203125},
{2180.833984375,1448.6962890625,10.8203125},
{2178.2666015625,1516.650390625,10.8203125},
{2153.0166015625,1490.373046875,10.8203125},
{2272.4833984375,1518.0166015625,30.031227111816},
{2297.7109375,1469.025390625,36.421875},
{2418.9482421875,1431.9580078125,10.8203125},
{2465.544921875,1405.8095703125,10.90625},
{2533.041015625,1398.083984375,10.90625},
{2567.5322265625,1402.701171875,11.066242218018},
{2557.7509765625,1363.9140625,10.8203125},
{2511.9814453125,1360.2021484375,10.827831268311},
{2533.5537109375,1507.3662109375,11.621562004089},
{2567.30078125,1552.279296875,13.40625},
{2460.572265625,1558.572265625,11.78125},
{2340.6484375,1576.1884765625,10.8203125},
{2299.3759765625,1564.9033203125,10.8203125},
{2308.8681640625,1648.3955078125,10.8203125},
{2284.109375,1722.8798828125,11.046875},
{2160.9697265625,1640.72265625,11.141441345215},
{2154.6376953125,1742.34375,11.107455253601},
{2337.4521484375,1758.85546875,12.453807830811},
{2436.3916015625,1672.55859375,10.8203125},
{2391.0537109375,1682.572265625,14.281055450439},
{2378.78515625,1681.8125,14.281055450439},
{2359.9970703125,1677.62109375,14.281055450439},
{2359.4423828125,1669.43359375,14.281055450439},
{2359.2080078125,1662.583984375,14.281055450439},
{2515.3623046875,1657.0458984375,11.0234375},
{2510.2685546875,1680.44921875,11.0234375},
{2491.578125,1680.6865234375,11.0234375},
{2480.6259765625,1681.3154296875,11.0234375},
{2399.8466796875,1838.314453125,11.65625},
{2277.68359375,1865.5302734375,10.8203125},
{2224.6591796875,1843.017578125,10.8203125},
{2204.5087890625,1899.7978515625,10.8203125},
{2375.44921875,2044.087890625,10.8203125},
{2545.6455078125,1972.0263671875,10.8203125},
{2634.0810546875,1979.8349609375,14.116060256958},
{2654.6181640625,1979.4892578125,14.116060256958},
{2646.3984375,2015.9638671875,10.81704044342},
{2637.265625,2017.2587890625,10.8203125},
{2613.2822265625,2050.720703125,14.116060256958},
{2470.232421875,2124.7041015625,10.8203125},
{2406.3818359375,2125.59765625,10.9314661026},
{2326.208984375,2118.970703125,10.828125},
{2220.5615234375,2124.310546875,10.8203125},
{2166.064453125,2162.904296875,10.8203125},
{2257.6494140625,2161.7294921875,10.8203125},
{2371.5078125,2166.208984375,10.826242446899},
{2446.927734375,2162.4189453125,10.8203125},
{2609.2236328125,2144.65625,14.116060256958},
{2636.4287109375,2183.9091796875,10.8203125},
{2611.072265625,2183.228515625,10.812986373901},
{2601.9326171875,2190.22265625,14.116060256958},
{2602.3974609375,2202.5283203125,14.116060256958},
{2624.9462890625,2200.6953125,10.8203125},
{2619.8818359375,2199.4599609375,10.8203125},
{2605.30859375,2208.388671875,10.8203125},
{2604.0712890625,2212.0478515625,10.8203125},
{2636.3720703125,2351.666015625,10.8203125},
{2628.2978515625,2347.75390625,10.8203125},
{2572.455078125,2331.640625,17.822208404541},
{2583.091796875,2366.2529296875,17.8203125},
{2610.43359375,2417.9580078125,10.8203125},
{2622.5302734375,2417.6943359375,10.8203125},
{2516.173828125,2225.677734375,10.8203125},
{2453.9091796875,2226.2451171875,10.866273880005},
{2429.359375,2226.2294921875,10.948439598083},
{2345.5625,2273.11328125,8.1477851867676},
{2352.953125,2307.685546875,8.1477851867676},
{2393.275390625,2307.5244140625,8.140625},
{2363.90625,2377.080078125,10.8203125},
{2445.9287109375,2376.3408203125,12.163512229919},
{2448.240234375,2257.0556640625,10.8203125},
{2488.9228515625,2397.712890625,10.8203125},
{2484.8642578125,2356.818359375,4.2109375},
{2491.443359375,2397.615234375,4.2109375},
{2248.23828125,2397.7373046875,10.8203125},
{2212.654296875,2341.794921875,10.8203125},
{2180.888671875,2292.33984375,10.8203125},
{2243.9453125,2522.1337890625,10.8203125},
{2271.673828125,2537.2412109375,10.8203125},
{2321.2998046875,2531.94140625,10.8203125},
{2331.1904296875,2531.1513671875,10.8203125},
{952.1337890625,-910.8427734375,45.765625},
{813.654296875,-1005.595703125,27.943950653076},
{766.28515625,-1011.6015625,24.109375},
{976.5546875,-1070.9052734375,26.988595962524},
{976.326171875,-1091.7255859375,23.934619903564},
{972.2578125,-1122.3212890625,23.846771240234},
{982.3046875,-1162.3857421875,25.0859375},
{921.6982421875,-1299.1845703125,14.09375},
{922.126953125,-1287.5625,14.40625},
{919.2177734375,-1266.0234375,15.171875},
{919.419921875,-1252.0859375,16.380939483643},
{726.51953125,-1275.85546875,13.6484375},
{954.126953125,-1336.431640625,13.538691520691},
{875.08984375,-1504.677734375,12.657918930054},
{851.09375,-1519.935546875,13.691524505615},
{878.4921875,-1514.6591796875,14.352069854736},
{762.6962890625,-1563.6318359375,13.553644180298},
{732.2548828125,-1477.767578125,5.46875},
{719.1220703125,-1476.7841796875,5.46875},
{789.1220703125,-1324.5078125,-0.5078125},
{852.841796875,-1391.2421875,-0.50146150588989},
{843.9853515625,-1390.5986328125,-1.3003606796265},
{726.6962890625,-1450.935546875,17.6953125},
{608.0302734375,-1475.2041015625,14.644786834717},
{652.9443359375,-1618.94921875,15},
{655.5556640625,-1640.4521484375,15.861747741699},
{655.876953125,-1650.0732421875,15.408567428589},
{487.3505859375,-1639.61328125,23.703125},
{299.43359375,-1611.5322265625,33.120010375977},
{279.83984375,-1615.5439453125,33.253612518311},
{277.546875,-1599.9365234375,33.069110870361},
{357.3642578125,-1394.314453125,14.438846588135},
{374.984375,-1384.0029296875,14.462802886963},
{391.921875,-1374.3095703125,14.819017410278},
{595.61328125,-1250.6875,18.295663833618},
{617.681640625,-1331.0546875,13.644295692444},
{297.146484375,-1490.69140625,24.59375},
{288.357421875,-1544.0625,24.59375},
{364.099609375,-1557.318359375,32.909343719482},
{409.57421875,-1601.76171875,27.14465713501},
{478.35546875,-1537.6982421875,19.478967666626},
{476.6376953125,-1497.7607421875,20.458106994629},
{660.5947265625,-1525.875,14.8515625},
{657.7060546875,-1480.9951171875,14.8515625},
{684.3662109375,-1435.517578125,14.8515625},
{598.333984375,-1285.1640625,15.859577178955},
{895.5986328125,-1116.953125,24.197673797607},
{899.21875,-1068.703125,24.479953765869},
{811.0830078125,-1092.8251953125,25.78458404541},
{820.0927734375,-1092.373046875,25.795583724976},
{820.4970703125,-1109.12109375,25.796077728271},
{810.7294921875,-1109.046875,25.784152984619},
{811.0224609375,-1101.0810546875,25.784509658813},
},
["farm"] = {

{-1115.7578125,-1638.9384765625,76.3671875},
{-2635.875,714.337890625,27.943759918213},
{-1976.5029296875,427.15625,24.657264709473},
{-1354.087890625,2058.705078125,53.1171875},
{-1513.001953125,1978.2646484375,48.421875},
{-1513.3935546875,1971.8173828125,48.421875},
{-1504.04296875,1972.1533203125,48.421875},
{-1052.4267578125,1547.734375,33.437610626221},
{-641.3017578125,2715.2802734375,72.375},
{-624.716796875,2709.775390625,72.375},
{-604.4365234375,2715.7958984375,72.72306060791},
{-439.6220703125,2228.0205078125,43.109375},
{-377.25390625,2242.3759765625,42.618461608887},
{-375.56640625,2257.8310546875,43.06192779541},
{-400.951171875,2200.44140625,42.4296875},
{-392.611328125,2486.23828125,41.372394561768},
{-12.3974609375,2346.7666015625,24.140625},
{578.787109375,1224.7607421875,11.711267471313},
{572.88671875,1221.32421875,11.711267471313},
{639.8046875,1236.189453125,11.701827049255},
{418.4423828125,1165.1923828125,7.887414932251},
{407.7529296875,1162.9384765625,7.9095220565796},
{300.62890625,1141.271484375,9.1374855041504},
{-1078.2314453125,-1154.40625,129.21875},
{-1065.3251953125,-1157.4287109375,129.21875},
{-1036.728515625,-1185.537109375,129.21875},
{-1061.1689453125,-1205.46875,129.75645446777},
{-951.060546875,-530.763671875,25.953638076782},
{-914.5185546875,-533.6328125,25.953638076782},
{-923.6982421875,-497.7255859375,26.765625},
{-347.9560546875,-1045.6669921875,59.8125},
{-350.033203125,-1036.1044921875,59.6640625},
{-382.6474609375,-1040.46484375,58.928451538086},
{-385.662109375,-1153.30859375,69.518951416016},
{-382.6884765625,-1438.8076171875,26.14489364624},
{-382.8759765625,-1426.30078125,26.293727874756},
{-401.7822265625,-1419.7373046875,26.328125},
{-78.4384765625,-1169.9111328125,2.1367826461792},
{-68.74609375,-1545.6875,3.0043075084686},
{-102.8818359375,-1575.30859375,2.6171875},
{-91.2294921875,-1592.5517578125,3.0043075084686},
{-418.8896484375,-1759.2001953125,6.21875},
{-282.98046875,-2174.5419921875,28.661544799805},
{-265.767578125,-2213.1220703125,29.041954040527},
{-39.7099609375,-2493.8671875,36.6484375},
{-27.7490234375,-2485.369140625,36.6484375},
{-13.517578125,-2500.9833984375,36.655464172363},
{-17.583984375,-2527.06640625,36.655464172363},
{24.4990234375,-2646.6298828125,40.464256286621},
{33.4814453125,-2649.908203125,40.728469848633},
{-1562.140625,-2733.275390625,48.743457794189},
{-1623.455078125,-2693.2626953125,48.742660522461},
{-2070.529296875,-2317.3115234375,30.731250762939},
{-2075.9306640625,-2312.3330078125,31.13125038147},
{-2191.921875,-2255.1806640625,33.3203125},
{-2198.93359375,-2243.5791015625,33.3203125},
{-2409.8232421875,-2189.9716796875,34.0390625},
{-2816.1865234375,-1530.6953125,140.84375},
{-1864.6572265625,-1559.265625,22.2109375},
{-1424.2744140625,-1478.6591796875,105.03207397461},
{-1438.732421875,-1544.6201171875,102.18502807617},
{-1462.2158203125,-1582.9296875,101.7578125},
{-1449.9501953125,-1459.2919921875,101.7578125},
{-607.5927734375,-1073.896484375,23.499340057373},
{-594.6728515625,-1057.0361328125,23.355651855469},
{-576.5341796875,-1032.095703125,23.832122802734},
{-574.740234375,-1484.22265625,14.34375},
{-1634.10546875,-2232.53515625,31.4765625},
{-1115.6142578125,-1637.23828125,76.3671875},
{-568.48046875,-1482.4150390625,10.008075714111},
{-746.8447265625,-131.2373046875,65.835411071777},
{-758.3359375,-131.5419921875,65.835411071777},
{-548.3115234375,-75.208984375,62.859375},
{-542.7138671875,-60.947265625,62.9921875},
{-545.4716796875,-196.5,78.413536071777},
{-561.58984375,-176.9716796875,78.413543701172},
{-487.962890625,-168.33984375,78.2109375},
{-473.134765625,-168.4306640625,78.2109375},
{-59.7998046875,84.2744140625,3.1171875},
{-48.4873046875,27.51953125,6.484375},
{-20.6171875,81.9970703125,3.1096496582031},
{-89.615234375,-54.6318359375,3.1171875},
{-120.4091796875,-102.11328125,3.1180820465088},
{-70.751953125,-98.4501953125,3.1180820465088},
{-59.31640625,48.4609375,6.4765625},
{-66.6845703125,38.744140625,6.4760594367981},
{-144.732421875,-50.1650390625,3.1171875},
{-61.4541015625,32.8349609375,3.1102695465088},
{-109.1025390625,-3.560546875,3.1171875},
{-70.8857421875,37.3623046875,3.1102695465088},
{-52.908203125,56.3974609375,3.1102695465088},
{-35.3310546875,52.841796875,3.109375},
{-91.349609375,-24.6943359375,3.1171875},
{-74.087890625,-109.162109375,3.1180820465088},
{-144.634765625,-96.06640625,3.1180820465088},
{-144.7724609375,-86.36328125,3.1180820465088},
{374.4228515625,-116.408203125,1.2477531433105},
{357.5263671875,-116.6533203125,1.2581691741943},
{354.2265625,-116.6494140625,1.260570526123},
{867.8134765625,-24.603515625,64.0390625},
{869.24609375,-16.4560546875,63.1953125},
{1918.212890625,173.666015625,37.269790649414},
{1914.94140625,152.7763671875,37.230663299561},
{1932.447265625,146.6201171875,37.28125},
{1568.1416015625,29.9248046875,24.1640625},
{1566.48828125,23.4306640625,24.1640625},
{1549.2861328125,13.6142578125,24.143926620483},
{1540.6923828125,12.3232421875,24.136585235596},
{1539.20703125,18.298828125,24.140625},
{1547.556640625,21.19140625,24.140625},
{1513.83203125,19.08984375,24.140625},
{1512.51171875,9.712890625,24.140625},
{1519.1669921875,14.900390625,24.140625},
{1546.9169921875,-34.158203125,21.302310943604},
{1553.822265625,-24.1748046875,21.377689361572},
{1050.8388671875,-313.5302734375,73.99308013916},
{1040.072265625,-299.3740234375,73.99308013916},
{1051.3291015625,-287.40234375,73.99308013916},
{1024.8525390625,-313.1611328125,73.99308013916},
{1012.921875,-298.2265625,73.99308013916},
{1013.6298828125,-286.1455078125,73.99308013916},
},
["supermarket"] = {

{-2442.3359375,754.7587890625,35.171875},
{2205.326171875,-2508.48828125,13.76850605011},
{-2671.720703125,257.9287109375,4.6328125},
{2136.4296875,-2290.13671875,20.664632797241},
{-2520.8330078125,-36.458984375,25.6171875},
{1923.390625,-2128.73046875,13.578104019165},
{1975.5244140625,-2013.361328125,13.546875},
{-2529.3408203125,-1.025390625,25.6171875},
{-2323.716796875,-158.8447265625,35.5546875},
{1765.7021484375,-2020.013671875,14.140814781189},
{1950.662109375,-1985.2998046875,13.546875},
{2403.4306640625,-1899.1259765625,13.546875},
{2517.2373046875,-1957.5498046875,16.79335975647},
{2461.3701171875,-1943.20703125,16.887882232666},
{2483.2880859375,-1958.69921875,13.581447601318},
{-2336.8671875,-166.53125,35.5546875},
{2046.83984375,-1900.123046875,13.553800582886},
{-1816.5380859375,618.6845703125,35.171875},
{1579.89453125,-1800.193359375,13.24654006958},
{1568.623046875,-1898.0087890625,13.560886383057},
{-2191.6728515625,636.6650390625,49.442939758301},
{822.326171875,-1756.5634765625,13.654552459717},
{501.1884765625,-1757.45703125,14.176206588745},
{353.2783203125,-2034.671875,7.8359375},
{352.927734375,-2030.24609375,7.8359375},
{-2767.8701171875,788.8642578125,52.78125},
{-1912.4794921875,827.966796875,35.234931945801},
{-2355.81640625,1008.0888671875,50.8984375},
{-2524.49609375,1216.2236328125,37.668563842773},
{-2491.9248046875,2363.158203125,10.272946357727},
{1048.5634765625,-1584.5595703125,13.523545265198},
{1066.6240234375,-1605.919921875,13.613391876221},
{1113.6767578125,-1605.8408203125,13.647103309631},
{1123.29296875,-1609.0283203125,13.60457611084},
{1123.662109375,-1633.3466796875,13.669480323792},
{1104.9833984375,-1632.740234375,13.605573654175},
{1079,-1632.494140625,13.58229637146},
{1069.4130859375,-1632.072265625,13.594591140747},
{1074.9169921875,-1604.5244140625,20.494478225708},
{1081.3330078125,-1633.19140625,20.4938621521},
{1111.6103515625,-1634.0859375,20.561660766602},
{1162.0361328125,-1585.29296875,13.546875},
{1162.076171875,-1602.0419921875,13.546875},
{-1808.5185546875,946.10546875,24.890625},
{-1321.904296875,2703.63671875,50.26628112793},
{-1272.349609375,2712.6669921875,50.26628112793},
{-1450.51171875,2593.8076171875,55.8359375},
{-1440.2353515625,2609.853515625,55.8359375},
{-1720.9404296875,1360.052734375,7.1853160858154},
{-1509.32421875,2609.998046875,55.8359375},
{2711.244140625,-1497.6298828125,30.553512573242},
{2633.6201171875,-1342.5322265625,36.192161560059},
{2710.8974609375,-1288.3837890625,58.9453125},
{2711.1044921875,-1310.6787109375,58.9453125},
{2153.3876953125,-1013.435546875,62.928932189941},
{2014.298828125,-1078.955078125,24.841756820679},
{2353.107421875,-1358.89453125,24.3984375},
{2000.6201171875,-1282.7119140625,23.971115112305},
{1982.6611328125,-1282.6025390625,23.971883773804},
{2007.140625,-1282.2138671875,23.974639892578},
{1974.5302734375,-1285.033203125,28.491893768311},
{2001.1806640625,-1285.1396484375,28.488073348999},
{1929.509765625,-1775.4658203125,13.546875},
{-1212.65625,1830.96875,41.9296875},
{-1226.5849609375,1834.5458984375,41.653701782227},
{-856.6572265625,1536.330078125,22.587043762207},
{-745.498046875,1590,26.9821434021},
{2105.4404296875,-1808.6201171875,13.5546875},
{2101.9228515625,-1807.626953125,13.5546875},
{-552.03515625,2595.7861328125,53.93478012085},
{-553.451171875,2592.08984375,53.93478012085},
{-550.0869140625,2582.2275390625,53.93478012085},
{-550.2685546875,2609.255859375,53.93478012085},
{-315.140625,1773.8125,43.640625},
{2324.4580078125,-1645.021484375,14.827047348022},
{-310.9453125,1305.6240234375,53.664344787598},
{2472.3798828125,-1530.3017578125,24.186376571655},
{-289.3818359375,2691.306640625,62.6875},
{-254.7392578125,2603.1591796875,62.858154296875},
{-89.0263671875,1378.2607421875,10.469839096069},
{-102.7587890625,1373.509765625,10.2734375},
{662.833984375,1716.7861328125,7.1875},
{673.2060546875,1706.1298828125,7.1875},
{638.552734375,1684.0107421875,7.1875},
{642.9814453125,1678.396484375,7.1875},
{175.666015625,1174.2470703125,14.7578125},
{-168.9990234375,1032.6728515625,19.734413146973},
{982.8994140625,2563.0966796875,10.739549636841},
{1151.955078125,2072.2470703125,11.0625},
{1164.1435546875,2086.056640625,10.8203125},
{1156.6396484375,2100.333984375,11.0625},
{2150.5400390625,2734.6796875,11.176349639893},
{2170.517578125,2795.2265625,10.8203125},
{2812.8134765625,2588.619140625,10.081407546997},
{2825.5654296875,2604.57421875,10.8203125},
{2787.6826171875,2560.68359375,9.9147701263428},
{2756.58203125,2475.91796875,11.0625},
{2793.6455078125,2438.8818359375,11.0625},
{2801.7109375,2430.205078125,11.0625},
{2844.5390625,2412.0615234375,11.068956375122},
{2860.123046875,2428.44140625,11.068956375122},
{2883.734375,2450.9794921875,11.068956375122},
{2898.8232421875,2466.232421875,11.068956375122},
{2781.7880859375,1455.0029296875,10.771492004395},
{-2155.1611328125,-2460.2734375,30.8515625},
{1685.08984375,-2238.333984375,13.546875},
{251.3271484375,-57.4375,1.5703125},
{245.1015625,-60.158203125,1.5703125},
{255.708984375,-53.201171875,1.5703125},
{244.8916015625,-55.5947265625,1.5776442289352},
{248.775390625,-54.8583984375,1.5776442289352},
{872.1162109375,-26.212890625,63.884567260742},
{1367.564453125,248.1337890625,19.566932678223},
{1415.71484375,261.328125,19.552904129028},
{2331.833984375,75.078125,26.620975494385},
{1153.7890625,-1458.7431640625,15.796875},
{1199.3037109375,-919.005859375,43.116374969482},
{1314.509765625,-898.5380859375,39.578125},
{1306.6376953125,-898.564453125,39.578125},
{1557.8095703125,953.7001953125,10.812507629395},
{1552.1123046875,1044.982421875,10.8203125},
{1367.08984375,2223.5634765625,11.0234375},
{1377.6796875,2329.3935546875,10.8203125},
{1378.431640625,2366.939453125,10.818092346191},
{1693.8310546875,2208.4697265625,11.069177627563},
{1601.0966796875,2222.0966796875,11.0625},
{1886.0283203125,2080.9326171875,11.0625},
{1873.67578125,2072.310546875,11.0625},
{1961.6787109375,2445.6435546875,11.178249359131},
{1923.7177734375,2447.1787109375,11.368927955627},
{2052.4091796875,2044.4716796875,11.057899475098},
{2086.9853515625,2065.0859375,11.057899475098},
{2070.6796875,2097.708984375,11.057899475098},
{1966.67578125,2147.0322265625,10.8203125},
{1967.2861328125,2160.1875,10.8203125},
{2055.4130859375,2292.490234375,10.8203125},
{2103.365234375,2255.12109375,11.0234375},
{2103.427734375,2237.3427734375,11.0234375},
{2090.6962890625,2223.4677734375,11.0234375},
{2187.916015625,2474.2587890625,11.2421875},
{2070.8896484375,2439.0380859375,49.522216796875},
{2213.2841796875,2525.1650390625,10.8203125},
{2116.734375,897.189453125,11.1796875},
{2638.0927734375,1129.04296875,11.1796875},
{2217.1220703125,1432.0537109375,11.0546875},
{2198.0234375,1476.30859375,11.0546875},
{2193.53125,1678.6162109375,12.3671875},
{2637.6904296875,1672.421875,11.0234375},
{2623.0458984375,1716.439453125,11.0234375},
{2638.578125,1751.240234375,11.228747367859},
{2553.8359375,1845.1494140625,11.0234375},
{2572.3037109375,1903.2744140625,11.0234375},
{2598.5732421875,1888.44921875,11.0234375},
{2388.126953125,2022.107421875,10.8203125},
{2438.7197265625,2064.361328125,10.8203125},
{2491.0048828125,2065.0380859375,10.8203125},
{2482.8291015625,2003.43359375,10.8203125},
{2540.6533203125,2149.2666015625,10.8203125},
{2596.8427734375,2381.171875,17.8203125},
{2516.2470703125,2299.21484375,10.8203125},
{2423.166015625,2547.6044921875,10.8203125},
{2478.041015625,2529.080078125,10.830163002014},
{2470.125,2544.7138671875,22.078125},
{2283.6826171875,2547.439453125,10.8203125},
{1009.1875,-930.05078125,42.328125},
{823.54296875,-1024.171875,25.147163391113},
{812.2626953125,-1030.015625,24.830501556396},
{974.177734375,-1257.70703125,16.887786865234},
{996.978515625,-1296.158203125,13.546875},
{999.58984375,-1295.748046875,13.546875},
{928.103515625,-1352.8330078125,13.34375},
},
["military"] = {

{-2554.7705078125,-13.7060546875,12.671875},
{-1716.439453125,-43.021484375,3.5546875},
{-1670.8447265625,705.4541015625,30.6015625},
{-2176.123046875,718.9609375,53.890956878662},
{-1389.716796875,2637.3203125,55.984375},
{-1380.51171875,2641.134765625,55.625045776367},
{-345.6181640625,1535.7685546875,75.5625},
{-346.1875,1547.19140625,75.5625},
{-340.5126953125,1543.2158203125,75.5625},
{-347.9462890625,1607.69140625,75.882217407227},
{-308.9384765625,1541.392578125,75.5625},
{404.9765625,2478.1826171875,16.484375},
{154.5009765625,2412.947265625,17.55677986145},
{197.982421875,2434.8388671875,16.986110687256},
{314.771484375,2411.30859375,17.745491027832},
{331.2509765625,2591.3115234375,17.471616744995},
{279.2216796875,2641.8974609375,16.936672210693},
{130.1083984375,2583.8837890625,17.186950683594},
{209.400390625,2609.2880859375,17.347387313843},
{141.1826171875,1875.015625,17.843418121338},
{155.865234375,1903.4921875,18.6650390625},
{232.822265625,1841.21484375,17.640625},
{285.6748046875,1966.7314453125,17.640625},
{268.568359375,1954.2724609375,17.640625},
{282.6669921875,1943.1591796875,17.640625},
{285.3740234375,1979.07421875,17.640625},
{269.49609375,1986.1474609375,17.640625},
{282.0595703125,2000.0634765625,17.640625},
{284.240234375,2013.51953125,17.640625},
{268.6796875,2018.572265625,17.640625},
{280.6923828125,2033.57421875,17.640625},
{353.73828125,2030.513671875,23.867307662964},
{215.8583984375,1819.9404296875,6.4140625},
{250.48046875,1797.2734375,7.4140625},
{244.7841796875,1825.1845703125,7.5546875},
{260.3115234375,1815.8583984375,1.0078125},
{287.1142578125,1816.2734375,1.0078125},
{280.2822265625,1820.791015625,4.7176899909973},
{329.984375,1839.3076171875,7.828125},
{296.86328125,1846.36328125,7.7265625},
{273.1826171875,1873.0068359375,8.7578125},
{274.6279296875,1855.9345703125,8.7648944854736},
{266.8427734375,1891.8330078125,8.4375},
{269.0341796875,1876.6123046875,-3.471396446228},
{268.5,1891.5048828125,-12.860445022583},
{268.6533203125,1876.896484375,-22.242134094238},
{268.9384765625,1883.416015625,-30.09375},
{265.0361328125,1881.3916015625,-30.390625},
{266.6064453125,1894.2109375,33.8984375},
{-217.2509765625,978.083984375,19.498880386353},
{-315.3505859375,830.384765625,14.2421875},
{795.162109375,1686.50390625,5.28125},
{813.080078125,1673.8876953125,5.28125},
{777.697265625,1871.5849609375,4.9077544212341},
{1054.2607421875,2269.8408203125,10.8203125},
{2595.4658203125,2790.1005859375,10.8203125},
{-1422.9892578125,512.4384765625,3.0390625},
{-1376.5263671875,511.8603515625,3.0390625},
{-1368.65234375,496.662109375,3.0444478988647},
{-1340.92578125,491.7978515625,11.1953125},
{-1288.083984375,490.724609375,11.1953125},
{-1291.515625,512.4990234375,11.1953125},
{616.7314453125,-611.7666015625,17.2265625},
{1524.501953125,-1677.99609375,6.21875},
{1368.712890625,-1280.0537109375,13.546875},
{1752.4580078125,2080.4111328125,10.8203125},
{1767.5576171875,2080.3896484375,10.8203125},
{2158.8330078125,942.259765625,10.8203125},
{2200.185546875,1393.439453125,10.8203125},
{2346.017578125,1518.05078125,42.81559753418},
{2458.677734375,1922.0908203125,10.86473274231},
{2477.2314453125,1956.134765625,10.546496391296},
{2576.9140625,2081.4833984375,10.812986373901},
{2538.52734375,2084.9775390625,10.8203125},
{2238.0517578125,2231.6865234375,10.809753417969},
{2238.900390625,2236.65625,10.803951263428},
{2301.5126953125,2454.03515625,10.8203125},
{2339.0712890625,2457.0361328125,14.96875},
{2388.7509765625,2469.291015625,10.8203125},
{2294.79296875,2486.5478515625,3.2734375},
{2233.494140625,2467.16796875,-7.4475412368774},
{2233.9970703125,2448.5634765625,-7.453125},
},
}